/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;

class ChatOutputStream {
    protected static final int PACKET_HEADER = 100;
    protected static final int PACKET_TAIL = 101;
    private static boolean DEBUG = true;
    private static final String EOP = "\n";
    OutputStream out;

    ChatOutputStream(OutputStream outputStream) throws IOException {
        this.out = outputStream;
        DEBUG = false;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void write(char c) throws IOException {
        this.out.write(c);
        this.out.flush();
    }

    public void write(String string) throws IOException {
        if (DEBUG) {
            System.out.println("writing packet" + string);
        }
        string = String.valueOf(string) + EOP;
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        this.out.write(byArray);
        this.out.flush();
    }

    public void writePacket(ChatPacket_t chatPacket_t) throws IOException {
        this.write("100:" + chatPacket_t.getCode() + ":" + chatPacket_t.getSourceID() + ":" + chatPacket_t.getDestID() + ":" + chatPacket_t.getMessage() + ":" + 101);
    }
}

