/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.IOException;

class ChatFrame
extends Frame
implements ChatterImpl {
    private String myName;
    private String hisName;
    private Graphics g;
    private String[] iWrote;
    private String[] heWrote;
    private ChatServerHandler server;
    private Font myFont;
    private Font hisFont;
    private int myCharHeight;
    private int hisCharHeight;
    private FontMetrics myFm;
    private FontMetrics hisFm;
    private String myTmp;
    private String hisTmp;
    private int myLineCount = 1;
    private int hisLineCount = 1;
    private int myMaxLines;
    private int hisMaxLines;
    private static int over = 0;
    private static boolean DEBUG = false;

    ChatFrame(String string, ChatServerHandler chatServerHandler) {
        this.server = chatServerHandler;
        DEBUG = false;
        ((Component)this).setBackground(new Color(150, 200, 255));
        this.iWrote = new String[20];
        this.heWrote = new String[20];
        int n = 0;
        while (n <= 9) {
            this.iWrote[n] = " ";
            this.heWrote[n] = " ";
            ++n;
        }
    }

    public void appendToHis(String string) {
        char c = string.charAt(0);
        if (c == '\b') {
            this.heWrote[this.hisLineCount] = this.heWrote[this.hisLineCount].substring(0, this.heWrote[this.hisLineCount].length() - 1);
        } else if (c == '\\') {
            ++this.hisLineCount;
            this.heWrote[this.hisLineCount] = " ";
        } else {
            int n = this.hisLineCount;
            this.heWrote[n] = String.valueOf(this.heWrote[n]) + string;
        }
        this.g.setFont(this.hisFont);
        FontMetrics fontMetrics = this.g.getFontMetrics(this.hisFont);
        int n = fontMetrics.stringWidth(this.heWrote[this.hisLineCount]);
        this.repaint();
        if (n >= this.size().width - fontMetrics.charWidth('D') * 2) {
            ++this.hisLineCount;
            this.heWrote[this.hisLineCount] = " ";
        }
        if (this.hisMaxLines <= this.hisLineCount) {
            this.hisLineCount = 1;
            this.heWrote[this.hisLineCount] = " ";
        }
    }

    public void appendToMe() {
        this.g.setFont(this.myFont);
        FontMetrics fontMetrics = this.g.getFontMetrics(this.myFont);
        int n = fontMetrics.stringWidth(this.iWrote[this.myLineCount]);
        this.repaint();
        if (n >= this.size().width - fontMetrics.charWidth('D') * 2) {
            ++this.myLineCount;
            this.iWrote[this.myLineCount] = " ";
        }
        if (this.myMaxLines <= this.myLineCount) {
            this.myLineCount = 1;
            this.iWrote[this.myLineCount] = " ";
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            ((Component)this).hide();
            return true;
        }
        super.handleEvent(event);
        try {
            this.hisMaxLines = this.size().height / 2 / this.hisCharHeight;
            this.myMaxLines = this.size().height / 2 / this.myCharHeight;
            if (this.myLineCount > this.myMaxLines) {
                this.myLineCount = this.myMaxLines;
            }
            if (this.hisLineCount > this.hisMaxLines) {
                this.hisLineCount = this.hisMaxLines;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean keyDown(Event event, int n) {
        if (n == 8) {
            this.iWrote[this.myLineCount] = this.iWrote[this.myLineCount].substring(0, this.iWrote[this.myLineCount].length() - 1);
        } else if (n == 10 || n == 13) {
            n = 92;
            ++this.myLineCount;
            this.iWrote[this.myLineCount] = " ";
        } else {
            int n2 = this.myLineCount;
            this.iWrote[n2] = String.valueOf(this.iWrote[n2]) + (char)n;
        }
        try {
            this.server.chat((char)n);
        }
        catch (IOException iOException) {}
        this.appendToMe();
        return true;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n <= this.myMaxLines) {
            graphics.setFont(this.myFont);
            graphics.setColor(Color.yellow);
            graphics.drawString(this.iWrote[n], 2, n * this.myCharHeight + this.myCharHeight);
            ++n;
        }
        int n2 = 0;
        while (n2 <= this.hisMaxLines) {
            graphics.setFont(this.hisFont);
            graphics.setColor(Color.black);
            graphics.drawString(this.heWrote[n2], 2, n2 * this.hisCharHeight + this.size().height / 2);
            ++n2;
        }
    }

    public void show() {
        super.show();
        this.g = this.getGraphics();
        this.myFont = new Font("SansSerif", 3, 15);
        this.hisFont = new Font("Helvetica", 3, 15);
        this.g.setFont(this.myFont);
        FontMetrics fontMetrics = this.g.getFontMetrics(this.myFont);
        this.myCharHeight = fontMetrics.getHeight();
        ++this.myCharHeight;
        this.g.setFont(this.hisFont);
        FontMetrics fontMetrics2 = this.g.getFontMetrics(this.hisFont);
        this.hisCharHeight = fontMetrics2.getHeight();
        ++this.hisCharHeight;
        this.myTmp = " ";
        this.hisTmp = " ";
        this.hisMaxLines = this.size().height / 2 / this.hisCharHeight;
        this.myMaxLines = this.size().height / 2 / this.myCharHeight;
    }
}

