/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;

class ChatClientHandler
extends Observable
implements Runnable,
ChatterImpl {
    protected ChatSocket sock;
    protected ChatInputStream in;
    protected ChatOutputStream out;
    protected int myID;
    protected int destID;
    protected String name;
    protected static boolean DEBUG = false;

    ChatClientHandler(Socket socket, int n) throws IOException {
        block2: {
            this.name = null;
            this.sock = new ChatSocket(socket);
            this.myID = n;
            this.in = this.sock.getChatInputStream();
            this.out = this.sock.getChatOutputStream();
            DEBUG = false;
            try {
                System.out.println("New Chatter Says: " + this.in.readPacket().getMessage());
                this.out.writePacket(new ChatPacket_t(50009, 50011, this.myID, "Welcome to Chat Online"));
            }
            catch (Exception exception) {
                if (!DEBUG) break block2;
                exception.printStackTrace();
                System.out.println("Error in constructor ChatServerHandler");
            }
        }
    }

    public void chat(ChatPacket_t chatPacket_t) throws IOException {
        this.out.writePacket(chatPacket_t);
    }

    public void chooseFrom(Hashtable hashtable) throws IOException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            String string = ((ChatClientHandler)hashtable.get(n)).toString();
            if (n != this.myID) {
                this.out.writePacket(new ChatPacket_t(50000, n, this.myID, string));
            }
            if (!DEBUG) continue;
            System.out.println("Choose:" + string + "ID=" + n);
        }
    }

    private void forwardPacket(ChatPacket_t chatPacket_t) {
        if (chatPacket_t.getCode() == 50000) {
            this.name = chatPacket_t.getMessage();
        }
        this.setChanged();
        this.notifyObservers(chatPacket_t);
    }

    public void quit() throws IOException {
        this.in.close();
        this.out.close();
    }

    public void request(ChatPacket_t chatPacket_t) throws IOException {
        this.out.writePacket(chatPacket_t);
    }

    public void run() {
        try {
            ChatPacket_t chatPacket_t;
            do {
                chatPacket_t = this.in.readPacket();
                if (DEBUG) {
                    System.out.println("Got Packet" + chatPacket_t);
                }
                this.forwardPacket(chatPacket_t);
            } while (chatPacket_t.getCode() != 50007);
            return;
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("Exception in run method of ChatClientHandler" + exception);
                exception.printStackTrace();
            }
            System.out.println("Quit:Abnormal:Run()");
            this.forwardPacket(new ChatPacket_t(50007, this.myID, 50011, "Error reading"));
            try {
                this.in.close();
            }
            catch (Exception exception2) {}
            return;
        }
    }

    public String toString() {
        return this.name;
    }

    private void write(int n, int n2, String string) throws IOException {
        this.out.writePacket(new ChatPacket_t(n, this.myID, n2, string));
    }
}

