/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.SocketException;
import java.util.Observable;
import java.util.Observer;

public class Chat
extends Applet
implements ActionListener,
Observer,
ChatterImpl {
    private ChatServerHandler server;
    private String serverName;
    private boolean single = false;
    private String name;
    private String others_name;
    private Panel topPanel;
    private Label prompt;
    private TextField namefield;
    private StringBuffer iTold;
    private StringBuffer heTold;
    private Graphics g;
    private int charWidth;
    private int charHeight;
    private int curX;
    private int curY;
    private int width;
    private int height;
    private Button select;
    private Button quitButton;
    private ChatFrame myChat;
    private Panel selectPanel;
    private static int server_port = 9000;
    protected static boolean DEBUG = false;
    private Thread serverHandlerThread;
    private boolean connected = false;
    private List idList;

    void acceptConfirmed(int n) {
        this.others_name = this.getName(n);
        this.start_Chat();
    }

    void acceptRequest(int n) {
        this.others_name = this.getName(n);
        this.showStatus("challenged by " + this.others_name);
        this.server.acceptRequest(n, "str");
        this.start_Chat();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            Object object;
            block6: {
                block4: {
                    object = actionEvent.getSource();
                    if (object != this.select) break block4;
                    try {
                        this.request_him();
                    }
                    catch (IOException iOException) {
                        System.out.println("unable to request");
                        System.exit(0);
                    }
                    break block5;
                }
                if (object != this.namefield) break block6;
                this.remove(this.topPanel);
                TextComponent textComponent = (TextComponent)object;
                String string = textComponent.getText();
                this.server.setName(string);
                this.nameEntered(string);
                break block5;
            }
            if (object != this.quitButton) break block5;
            try {
                this.server.quit();
                this.serverHandlerThread.stop();
                this.remove(this.quitButton);
                ((Component)this.myChat).hide();
                this.name = null;
                this.connected = false;
                this.start();
                System.out.println("Quitting");
                this.validate();
            }
            catch (IOException iOException) {
                System.out.println("IOException while quitting");
            }
        }
    }

    void add(int n, String string) {
        if (DEBUG) {
            System.out.println("add called");
        }
        this.delete(n);
        this.idList.addItem("(" + n + ")  " + string);
        if (DEBUG) {
            System.out.println("Add over");
            System.out.println("Items in the list=" + this.idList.getItemCount());
        }
        this.showStatus("Choose any one from the list");
        this.validate();
    }

    public void appendToHis(String string) {
    }

    public void appendToMe(String string) {
    }

    private void askInfo() {
        if (DEBUG) {
            System.out.println("Inside Askinfo");
        }
        this.prompt = new Label("Enter your nic-name here!!:");
        this.namefield = new TextField(20);
        this.namefield.addActionListener(this);
        this.topPanel = new Panel();
        this.topPanel.setBackground(new Color(255, 255, 200));
        this.topPanel.add(this.prompt);
        this.topPanel.add(this.namefield);
        this.add("Center", this.topPanel);
    }

    void chat(int n, String string) {
        this.myChat.appendToHis(string);
        this.showStatus(" you are talking to" + this.others_name);
    }

    private void connect() throws IOException {
        try {
            this.showStatus("Connecting to " + this.serverName);
            if (DEBUG) {
                System.out.println("Connecting to " + this.serverName);
            }
            this.server = new ChatServerHandler(this.serverName, server_port);
            this.server.addObserver(this);
            this.serverHandlerThread = new Thread(this.server);
            this.serverHandlerThread.start();
            this.showStatus("Connected: " + this.serverName);
            this.connected = true;
        }
        catch (SocketException socketException) {
            this.showStatus("server not found");
            System.out.println("unable to connect to server");
        }
    }

    void delete(int n) {
        int n2 = 0;
        while (n2 < this.idList.getItemCount()) {
            String string = this.idList.getItem(n2);
            int n3 = Integer.parseInt(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
            if (n3 == n) {
                this.idList.delItem(n2);
                break;
            }
            ++n2;
        }
        if (this.idList.getItemCount() == 0) {
            this.showStatus("Wait for other's to arrive.");
        }
    }

    private String getName(int n) {
        int n2 = 0;
        while (n2 < this.idList.getItemCount()) {
            String string = this.idList.getItem(n2);
            int n3 = Integer.parseInt(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
            if (n3 == n) {
                return string.substring(string.indexOf(" ") + 3);
            }
            ++n2;
        }
        return null;
    }

    public void init() {
        this.width = this.size().width;
        this.height = this.size().height;
        DEBUG = false;
        this.idList = new List(1, false);
        this.setLayout(new BorderLayout());
        this.serverName = this.getCodeBase().getHost();
        if (this.serverName.equals("")) {
            this.serverName = "localhost";
        }
    }

    private void nameEntered(String string) {
        if (string.equals("")) {
            return;
        }
        this.name = string;
        if (this.idList != null) {
            this.remove(this.idList);
        }
        if (this.select != null) {
            this.remove(this.select);
        }
        this.selectPanel = new Panel();
        System.out.println("Items in the list=" + this.idList.getItemCount());
        this.selectPanel.add("South", this.idList);
        this.select = new Button("Select any one from the list");
        this.select.addActionListener(this);
        this.selectPanel.add("Center", this.select);
        this.add("North", this.selectPanel);
        this.validate();
        Font font = new Font("Helvetica", 1, 12);
        this.g = this.getGraphics();
        FontMetrics fontMetrics = this.g.getFontMetrics();
        this.charWidth = fontMetrics.stringWidth("c");
        this.charHeight = fontMetrics.getHeight();
        this.curX = 10;
        this.curY = 10;
        this.showStatus("Wait for some one to arrive.");
        if (this.topPanel != null) {
            this.remove(this.topPanel);
        }
    }

    void quit(int n) {
        if (this.others_name != null) {
            this.showStatus(String.valueOf(this.others_name) + " just quit.");
            System.out.println(String.valueOf(this.others_name) + " just quit.");
            this.delete(n);
            this.remove(this.quitButton);
            this.nameEntered(this.name);
            ((Component)this.myChat).hide();
            System.out.println("Our fellow chatter quitted");
        } else {
            this.delete(n);
        }
        this.validate();
    }

    private void request_him() throws IOException {
        String string = this.idList.getSelectedItem();
        if (string == null) {
            this.showStatus("Choose a player from the list then press Challenge");
        } else {
            this.selectPanel.remove(this.idList);
            this.selectPanel.remove(this.select);
            this.remove(this.selectPanel);
            int n = Integer.parseInt(string.substring(string.indexOf(40) + 1, string.indexOf(41)));
            this.showStatus("challenging: " + n);
            System.out.println("challenging: " + n);
            this.server.request(n);
            this.validate();
        }
    }

    public void start() {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (this.name == null) {
                if (this.topPanel != null) {
                    this.topPanel.remove(this.prompt);
                    this.topPanel.remove(this.namefield);
                    this.remove(this.topPanel);
                }
                this.askInfo();
                this.validate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.single = true;
            this.start_Chat();
        }
    }

    private void start_Chat() {
        if (this.single) {
            Frame frame = new Frame("Chat Online");
            ((Component)frame).setSize(200, 200);
            frame.setResizable(false);
            frame.show();
            this.showStatus("no server found How to Chat?????");
        } else {
            this.selectPanel.remove(this.idList);
            this.selectPanel.remove(this.select);
            this.remove(this.selectPanel);
            this.quitButton = new Button("quit!!");
            this.quitButton.addActionListener(this);
            this.add("East", this.quitButton);
            this.iTold = new StringBuffer();
            this.heTold = new StringBuffer();
            this.g.setColor(Color.green);
            System.out.println("opening chat Window");
            this.myChat = new ChatFrame("chat here", this.server);
            this.myChat.resize(600, 250);
            this.myChat.show();
            System.out.println("Chat Window Opened");
            this.showStatus("you are talking to " + this.others_name);
        }
        this.validate();
    }

    public void stop() {
    }

    public void update(Observable observable, Object object) {
        ChatPacket_t chatPacket_t = (ChatPacket_t)object;
        ChatServerHandler chatServerHandler = (ChatServerHandler)observable;
        if (DEBUG) {
            System.out.println("Packet" + chatPacket_t);
        }
        switch (chatPacket_t.getCode()) {
            case 50000: {
                System.out.println("Adding=" + chatPacket_t);
                this.add(chatPacket_t.getSourceID(), chatPacket_t.getMessage());
                break;
            }
            case 50003: {
                this.acceptRequest(chatPacket_t.getSourceID());
                break;
            }
            case 50004: {
                this.acceptConfirmed(chatPacket_t.getSourceID());
                break;
            }
            case 50001: {
                this.chat(chatPacket_t.getSourceID(), chatPacket_t.getMessage());
                break;
            }
            case 50007: {
                this.quit(chatPacket_t.getSourceID());
                break;
            }
            default: {
                System.out.println("Invalid Protocol" + chatPacket_t);
            }
            case 50005: 
        }
    }
}

