/* -*-Java-*- */
/*
 *  FileServer Component
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//25-5-1999
package gateway;
import java.io.*;
import java.net.*;
import java.util.*;
class GatewayClientHandler  implements Runnable{
	private BufferedReader in;
	private PrintWriter out;
	private Hashtable connectivityServers;
	private static final String END="end of message";
	private static final int PASS=1;
	private static final int FAIL=0;
	GatewayClientHandler(BufferedReader in,PrintWriter out){
		this.in=in;
		this.out=out;
		connectivityServers=new Hashtable();
	}
	public static void main(String []args){
		BufferedReader in=new BufferedReader(new
		InputStreamReader(System.in));
		PrintWriter out=new PrintWriter(System.out);
		GatewayClientHandler ch=new GatewayClientHandler(in,out);
		new Thread(ch).start();
	}
	public void run(){
		String comm[];
		try{
		while(true){
			doAction(parseCommand());
		}
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	private void doAction(String [] comm){
		BufferedReader inn=null;
		try{
		String command=comm[0].toLowerCase();
		if(command.equals("register"))
			inn=execRegister(comm);
		else
		if(command.equals("list"))
			inn=execList();
      else{
			out.println(FAIL+"Command Not Found");
			out.println(END);
			out.flush();
	  	return;
		}
		System.out.println(PASS+"Sending the results");
		String str;
		while((str=inn.readLine())!=null){
			if(str.equals(END)) break;
			out.println(str);
		}
		out.println(END);
		out.flush();
		System.out.println("results sent.....");
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	public String[] parseCommand() throws IOException{
		String line=in.readLine();
		if(line==null) {
			in.close();
			out.close();
			throw new IOException("connection closed");
		}
		StringTokenizer st=new StringTokenizer(line);
		String str[]=new String[st.countTokens()];
		int i=0;
		while(st.hasMoreElements()){
			str[i]=(String)st.nextElement();
			str[i].trim();
			i++;
		}
		return str;
	}
	protected void finalize(){
		System.out.println("Comm Handler:Collected");
	}
  private BufferedReader execRegister(String [] comm){
    connectivityServers.put(comm[1],comm[2]);
    return new BufferedReader(new InputStreamReader(new
    StringBufferInputStream("registered")));
  }
  private BufferedReader execList(){
    return new BufferedReader(new InputStreamReader( new
    StringBufferInputStream(connectivityServers.toString())));
  }
}
