/* -*-Java-*- */
/*
 *  FileServer Component
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.*;
import java.net.*;
class Put{
	private static final int FAIL=0;
	private static final int PASS=1;
	private static final int port=9999;
	Put(){}
	public BufferedReader put(String host,String remoteFile,
	String localFile){
		String retStr;
		try{
		Socket sock=new Socket(host,port);
		InputStream in=sock.getInputStream();
		OutputStream out=sock.getOutputStream();
		PrintWriter wr=new PrintWriter(out);
		wr.println("get "+remoteFile);
		OutputStream fout=new FileOutputStream(localFile);
		copy(in,fout);
		retStr=PASS+"File transferred";
		out.close();
		fout.close();
		in.close();
		}catch(Exception e){
			e.printStackTrace();
		retStr=FAIL+"Unable to transfer the file";
		}
		return new BufferedReader(new InputStreamReader(
		new StringBufferInputStream(retStr)));
	}
	private void copy(InputStream in,OutputStream out) throws
	IOException{
		int ch;
		int lastCh;
		lastCh=ch=-1;
		int i=0;
		while((ch=in.read())!=-1){
			switch(ch){
				case '\r':
				break;
				case '\n':
					if(ch==lastCh)
					return;
				default:
					out.write((byte)ch);
					lastCh=ch;
			}
		}
	}
}
			

