/* -*-Java-*- */
/*
 *  FileServer Component
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.awt.*;
import gateway.*;
import java.util.*;
import java.rmi.*;
//import com.sun.java.swing.*;
import java.io.*;
import browser.*;
class NetworkBrowser extends Panel{
  private java.awt.List machineList;
  private RemoteExecuter re;
  private static final String END="end of message";
  private java.awt.List dirList;
  private Gateway gateway;
  private Hashtable machines;
  private static String gatewayIP="localhost";
  private static int gatewayPort;
  private static final int port=9997;

  NetworkBrowser(String gatewayIP,int port){
    BrowserPanel panel=new BrowserPanel();
    this.gatewayIP=gatewayIP;
    this.gatewayPort=port;
    setLayout(new BorderLayout());
    machineList=new java.awt.List();
    dirList=new  java.awt.List();
    getMachineNames();
    dirList.setMultipleSelections(false);
    machineList.setMultipleSelections(false);
    add(panel.add(machineList));
 
  }
  public static void main(String []args){
    if(args.length<2){
      System.out.println("Usage java NetworkBrowser <gateway m/c>"+
      "<port>");
      System.exit(1);
    }
    Frame frm=new Frame();
    frm.resize(400,400);
    NetworkBrowser nb=new NetworkBrowser(args[0],Integer.parseInt(args[1]));
    frm.add(nb);
    frm.show();
  }

  private void getMachineNames(){
    try{
      System.setSecurityManager(new RMISecurityManager());
      }catch(Exception e){
        e.printStackTrace();
      }
    try{
      String url=new String("//"+gatewayIP+":"+gatewayPort+"/Gateway");
      System.out.println("Gateway Found");
      gateway=(Gateway)Naming.lookup(url);
      machines=gateway.list();
      Enumeration en=machines.keys();
      int i=0;
      while(en.hasMoreElements()){

        String name=(String)en.nextElement();
        System.out.println("Machine--"+name+"--found");
        machineList.add(name);


      }
    }catch(Exception ex){
      ex.printStackTrace();
    }
  }
  public boolean action(Event e,Object o){
    if(e.target.equals(machineList)){
      String name=machineList.getSelectedItem();
      int port=Integer.parseInt((String)machines.get(name));
       remove(machineList);
       add(dirList);
       validate();

      try{
      exploreMachine(name,port);
      }catch(Exception ex){
        System.out.println("unable to connect to the machine");
        ex.printStackTrace();
      }

//      Explore explore=new Explore(this,name,port);
    }
   if(e.target.equals(dirList)){
      String dirName=dirList.getSelectedItem();
      if(dirName.startsWith("["))
        try{
          dirList.clear();
          exploreDir(dirName.substring(1,dirName.length()-1));
        }catch(Exception ex){
          System.out.println("unable to connect to the machine");
          ex.printStackTrace();
        }
    }
    return true;
  }
  private void exploreMachine(String machineName,int port) throws Exception{
    re=new RemoteExecuter(machineName,port);
    exploreDir(".");
  }
  private void exploreDir(String dirName) throws Exception{
    BufferedReader in;
    String str;
    in=re.exec("cd"+" "+dirName);
    while((str=in.readLine())!=null){
    if(str.equals(END)) break;
    System.out.println(str);
    }
    in=re.exec("ls");
    int colonIndex1,colonIndex2;
    String fileName,fileType;
    System.out.println(in.readLine());
    dirList.add("[..]");
    while((str=in.readLine())!=null){
      if(str.equals(END)) break;
      colonIndex1=str.indexOf(':');
      colonIndex2=str.indexOf(':',colonIndex1+1);
      fileType=str.substring(colonIndex1+1,colonIndex2);
      fileName=str.substring(0,colonIndex1);
      System.out.println("fileName="+fileName+"and fileType="+fileType);
      if(fileType.equals("1")){
      fileName="["+fileName+"]";
      }
      dirList.add(fileName);
    }




  }
}




