/* -*-Java-*- */
/*
 *  FileServer Component
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//6-4-1999
import java.io.*;
import java.net.*;
class LocalExecuter{
	private String cwd="/home/systpe/rakesh";
	private String home="/home/systpe/rakesh";
	private static Ls ls;
	private static Get getObj;
	private Pwd pwdObj;
	private static final int PASS=1;
	private static final int FAIL=0;


	public static void main(String []args) throws Exception{
		LocalExecuter ce=new LocalExecuter();
		ce.list("file://localhost/home/systpe/rakesh/.");
		ce.cd(".");
	}
	LocalExecuter(){
		File f=new File("");
		home=f.getAbsolutePath();
		//home=home.substring(0,home.lastIndexOf(File.separatorChar));
		cwd=home;
		pwdObj.pwd=cwd;
		ls=new Ls();
		getObj=new Get();
	}
	public BufferedReader list(String url) throws MalformedURLException{
		return ls.ls(cwd+File.separatorChar+url);
	}
	public BufferedReader pwd() {
		return new BufferedReader(new InputStreamReader(new
		StringBufferInputStream(cwd)));
	}
	public BufferedReader get(String remoteHost,String remoteFile,
		String localFile){
		return getObj.get(remoteHost,remoteFile,cwd+File.separatorChar+
		localFile);

	}
	public BufferedReader put(String remoteHost,String localFile,
		String remoteFile){
		return getObj.put(remoteHost,cwd+File.separatorChar+localFile,remoteFile);

	}
	public BufferedReader exec(String command[]) throws IOException{
		Runtime rt=Runtime.getRuntime();
		rt.exec(command);
		return new BufferedReader(
    new InputStreamReader(
    new StringBufferInputStream("Executer")));
	}
	public BufferedReader cd(String dir){
		String returnStr;
		String tmpDir=cwd;
		if(dir.equals("..")){
			cwd=cwd.substring(0,cwd.lastIndexOf(File.separatorChar));
		}
		else
		if(dir.equals("home"))
		cwd=home;
		else
		cwd=cwd+File.separatorChar+dir;
		System.out.println("cwd="+cwd);
		File f=new File(cwd);
		if(f.exists()){
			returnStr="Current Directory now"+cwd;
		}
		else {
			returnStr="No Such File or Directory";
			cwd=tmpDir;
		}
		pwdObj.pwd=cwd;
		return new BufferedReader(new InputStreamReader(
		new StringBufferInputStream(returnStr)));
	}
	protected void finalize(){
		System.out.println("Comm Exec Collected"+this);
	}

}
