/* -*-Java-*- */
/*
 *  FileServer Component
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


import java.net.*;
import java.net.Socket;
import java.net.ServerSocket;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public abstract class GenericServer extends ServerSocket implements Runnable{
	private Socket sock;
	GenericServer(int port) throws java.io.IOException{
		super(port);
	}
	public  void start() throws java.io.IOException{
	System.out.println("Server Started");
		while(true){
			sock=accept();
			System.out.println("socket Accepted"+sock.getPort());
			new Thread(this).start();
		}
	}
	public void run() {
		try{
		doService(sock.getInputStream(),sock.getOutputStream());
		}catch(Exception e){
			e.printStackTrace();
		}
	}
/*
	abstract public void doService(InputStream in,OutputStream out) throws
	Exception;*/
	public void doService(InputStream in,OutputStream out) throws
	Exception{
		int i;
		while((i=in.read())!=-1){
			out.write(i);
		}
	}
	
}


