/* -*-Java-*- */
/*
 *  FileServer Component
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//9-4-1999
import java.io.*;
import java.net.*;
import java.util.*;
class Executer {
	private LocalExecuter le;
  private String currentConnection="";
	private  Hashtable remoteExecuters;
	private static final int PASS=1;
	private static final int FAIL=0;
	//private Cp cp;
	Executer(){
		remoteExecuters=new Hashtable();
		le=new LocalExecuter();


	}
	public BufferedReader execLs(String [] comm) throws
	Exception{
		if(comm.length==1){
     currentConnection="localhost";
			return le.list(".");
		}
		CommandURL url=new CommandURL(comm[1]);
    currentConnection=url.getHost();
		if(url.getHost().equals("localhost")){
			return le.list(url.getFile());
		}
		else{
			System.out.println("Remote host"+url.getHost());
			System.out.println("Remote dir"+url.getFile());
			RemoteExecuter re=getRemoteExecuter(url.getHost());
			return re.exec("ls "+url.getFile());
		}
	}
	public BufferedReader execCd(String []comm) throws
	Exception{
		if(comm.length==1){
			return le.cd("home");
		}
		CommandURL url=new CommandURL(comm[1]);
		if(url.getHost().equals("localhost")){
			return le.cd(url.getFile());
		}
		else{
			RemoteExecuter re=getRemoteExecuter(url.getHost());
			return re.exec("cd "+url.getFile());
		}
	}

	private RemoteExecuter getRemoteExecuter(String host) throws Exception{
		RemoteExecuter re=(RemoteExecuter)
		remoteExecuters.get(host);
		System.out.println("re="+re);
		if(re==null) {
		re=new RemoteExecuter(host,9999);
		remoteExecuters.put(host,re);
		}
		return re;
	}
	/**
	 * Copy a file from one machine to another
	 * cp marine:hello.java varsha:hello1.java
	 * Strategy here is to contact marine and tell it to execute 
	 * Command "put hello.java varsha:hello1.java",Simple !! isn't it
	 */

	public BufferedReader execCp(String []comm) throws Exception{
    /*	return new BufferedReader(new InputStreamReader(
			new StringBufferInputStream(FAIL+"Sorry operation not implented"+
			" Yet")));*/
		CommandURL url1=new CommandURL(comm[1]);
		String host=url1.getHost();
		String file=url1.getFile();
		RemoteExecuter re=getRemoteExecuter(host);
		return re.exec("put "+file+" "+comm[2]);
	}

	public BufferedReader execGet(String [] args) throws Exception{
		if(args.length<2){
			return new BufferedReader(new InputStreamReader(
			new StringBufferInputStream(FAIL+"Insufficient"+
			"Argument")));
		}
		CommandURL url=new CommandURL(args[1]);
		String localFile;
		//IF there's no third parameter then the localfile name is
		//Same as remote file name
		if(args.length<3){
		localFile=url.getFile();
		}
		else localFile=args[2];
		BufferedReader rd=remotePwd(url.getHost());
		return le.get(url.getHost(),rd.readLine()+File.separatorChar+
		url.getFile(),localFile);
	}
	public BufferedReader execPut(String [] args) throws Exception{
		if(args.length<3){
			return new BufferedReader(new InputStreamReader(
			new StringBufferInputStream(FAIL+"Insufficient"+
			"Argument")));
		}
		CommandURL url=new CommandURL(args[2]);
		String remoteFile;
		if(url.getFile().length()<1){
			remoteFile=args[1];
		}
		else
			remoteFile=url.getFile();
		BufferedReader rd=remotePwd(url.getHost());
		return le.put(url.getHost(),args[1],rd.readLine()+File.separatorChar+ remoteFile);
	}
	public BufferedReader execPwd(String []comm) throws Exception{
		if(comm.length==1)
			return le.pwd();
		else
			return remotePwd(comm[1]);
	}
	public BufferedReader remotePwd(String host) throws Exception{
			RemoteExecuter re=getRemoteExecuter(host);
			return re.exec("pwd");
	}
	public BufferedReader execExec(String args[]) throws Exception{
	String []str=new String[args.length-1];
	System.arraycopy(args,1,str,0,args.length);
	CommandURL url=new CommandURL(str[0]);
	if(url.equals("localhost"))
		le.exec(str);
	else{
		StringBuffer strBuff=new StringBuffer();
		for(int i=0;i<str.length;i++){
		strBuff.append(str[i]+" ");
		}
		RemoteExecuter re=getRemoteExecuter(url.getHost());
		return re.exec("exec "+strBuff.toString());
	}



	return null;
	}

	protected void finalize(){
		System.out.println("Executer:Collected");
	}

}
