/* -*-Java-*- */
/*
 *  FileServer Component
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//8-4-1999
import java.io.*;
import java.net.*;
import java.rmi.*;
import gateway.*;
class Driver implements Runnable{
	private GenericServer gs;

  private static String gatewayIP="localhost";

	Driver(GenericServer gs,String gateway,int port){
    gatewayIP=gateway;
    try{
    System.setSecurityManager(new RMISecurityManager());
    }catch(Exception e){}
    try{
    Gateway gatewayObject;
    String url=new String("//"+gatewayIP+":"+port+"/Gateway");
    System.out.println("Looking for Gateway");
    gatewayObject=(Gateway)Naming.lookup(url);
    gatewayObject.register(
    InetAddress.getLocalHost().getHostName(),9999);
    }catch(Exception e){
      System.out.println("Exception"+e);
    }

    this.gs=gs;
	}
	public static void main(String []args) throws IOException{
    if(args.length<2){
      System.out.println("Usage java Driver gateway_m/c port");
      System.exit(1);
    }
    int port=Integer.parseInt(args[1]);
		RemoteServer rs=new RemoteServer(9999);
		GetServer gets=new GetServer(9921);
		Driver drv1=new Driver(rs,args[0],port);
		new Thread(drv1).start();
		Driver drv2=new Driver(gets,args[0],port);
		new Thread(drv2).start();
	}
	public void run(){
		try{
		gs.start();
		}catch(Exception e){
			e.printStackTrace();
		}
	}
}

