/* -*-Java-*- */
/*
 *  FileServer Component
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//5-4-1999
import java.io.*;
import java.net.*;
import java.util.*;
class CommandHandler  implements Runnable{
	private BufferedReader in;
	private PrintWriter out;
	private Executer executer;
	private static final String END="end of message";
	private static final int PASS=1;
	private static final int FAIL=0;
	CommandHandler(BufferedReader in,PrintWriter out){
		this.in=in;
		this.out=out;
		executer=new Executer();
	}
	public static void main(String []args){
		BufferedReader in=new BufferedReader(new 
		InputStreamReader(System.in));
		PrintWriter out=new PrintWriter(System.out);
		CommandHandler ch=new CommandHandler(in,out);
		new Thread(ch).start();
	}
	public void run(){
		String comm[];
		try{
		while(true){
			doAction(parseCommand());
		}
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	private void doAction(String [] comm){
		BufferedReader inn=null;
		try{
		String command=comm[0].toLowerCase();
		if(command.equals("ls"))
			inn=executer.execLs(comm);
		else
		if(command.equals("cd"))
			inn=executer.execCd(comm);
		else
		if(command.equals("cp"))
			inn=executer.execCp(comm);
		else
		if(command.equals("get"))
			inn=executer.execGet(comm);
		else
		if(command.equals("put"))
			inn=executer.execPut(comm);
		else
		if(command.equals("pwd"))
			inn=executer.execPwd(comm);
		else
		if(command.equals("exec"))
			inn=executer.execExec(comm);
    else
    if(command.equals("quit")){
      out.println(FAIL+"Press CTRL+C");
			out.println(END);
    }
		else{
			out.println(FAIL+"Command Not Found");
			out.println(END);
			out.flush();
		return;
		}
		System.out.println(PASS+"Sending the results");
		String str;
		while((str=inn.readLine())!=null){
			if(str.equals(END)) break;
			out.println(str);
		}
		out.println(END);
		out.flush();
		System.out.println("results sent.....");
		}catch(Exception e){
			e.printStackTrace();
      out.println(FAIL+"I AM NOT A FOOL!!");
			out.println(END);
			out.flush();
		}
	}
	public String[] parseCommand() throws IOException{
		String line=in.readLine();
		if(line==null) {
			in.close();
			out.close();
			throw new IOException("connection closed");
		}
		StringTokenizer st=new StringTokenizer(line);
		String str[]=new String[st.countTokens()];
		int i=0;
		while(st.hasMoreElements()){
			str[i]=(String)st.nextElement();
			str[i].trim();
			i++;
		}
		return str;
	}
	protected void finalize(){
		System.out.println("Comm Handler:Collected");
	}
		
}
