import java.applet.*;
import java.awt.image.*;
import java.awt.*;

public class hint extends Applet implements Runnable {
	private DirectImage  bitmap;
	private Image        bitImg;
	private int          xs, ys;
	private int          width, height;
	private Thread       ticker;
	private boolean      running = false;
	private int background[] = new int [400*300];
	private int unbroken[] = new int [400*300];

	int marker[] = new int [100*100];


	public void init () {
        int t,p;
        Image back;
		Image imgMarker;


		width = 400;
		height = 300;
		bitmap = new DirectImage(width, height);
		bitImg = createImage(bitmap);


		MediaTracker tracker = new MediaTracker (this);
		back = getImage( getCodeBase(), "back.gif");  //get background image
		tracker.addImage (back,1);
		try {tracker.waitForID(1);}
		catch (InterruptedException ie)  { return; }

		imgMarker = getImage(getCodeBase(), "marker.gif");
		tracker.addImage (imgMarker,1);
		try {tracker.waitForID(1);}
		catch (InterruptedException ie)  { return; }


		PixelGrabber pgback = new PixelGrabber (back,0,0,width,height,background,0,width);
		try {
		pgback.grabPixels();
		} catch (InterruptedException e) {e.printStackTrace (); }


		PixelGrabber pgMarker = new PixelGrabber (imgMarker,0,0,100,100,marker,0,100);
		try {
		pgMarker.grabPixels();
		} catch (InterruptedException e) {e.printStackTrace (); }

	    back.flush();
        imgMarker.flush();


	}

	public void paint (Graphics g) {
		bitImg.flush();
		g.drawImage(bitImg, 0, 0, null);
	}

	public void update (Graphics g) {
		paint(g);
	}

	public void run () {
		int off = 0;
		int p,t,pp,tt,ppp,ttt,boardIndex;

		while (running) {

		for (p=0;p<400*300;p++)
			unbroken[p] = background[p];
			waveForm(off += 4);

			for (t=0;t<100;t++)
			  for (p=0;p<100;p++)
			    unbroken[p+80300+(t*400)]=marker[p+(t*100)];


			for (p=0;p<400*300;p++)
			bitmap.pixels[p] = unbroken[p];

			repaint();
			try {
				ticker.sleep(1000 / 30);
			} catch (InterruptedException e) { ; }
		}
	}


		public void waveForm (int off) {
			//for (int ii = 0; ii < bitmap.pixels.length; ii++)
			//	bitmap.pixels[ii] = 0xFF000000;
			int base = (height >> 1);
			double twoPI = Math.PI * 2;
			double scale = (double) height * 0.75;
			for (int x = 0; x < width; x++) {
				double rad = ((x + off) * twoPI) / width;
				int y = ((int) (Math.sin(rad) * scale) / 2) + base;
				unbroken[y * bitmap.width + x] = 0xFFFFFFFF;
			}
		}


	public void start () {
		if (ticker == null  ||  !ticker.isAlive()) {
			running = true;
			ticker = new Thread(this);
			ticker.setPriority(Thread.MIN_PRIORITY + 1);
			ticker.start();
		}
	}

	public void stop () {
		running = false;
	}




	static int randomNumber (int low, int high) {
	   		// returns a random number between low and high, inclusive
	   		return (int)(java.lang.Math.random() * (high - low + 1) + low);
		} // randomNumber

}
