/***********************************************
Chaplin Corp.   1999
http://www.angelfire.com/id/chaplincorp
Chaplin_Corp@hotmail.com
------------------
PcLock v1.1
locks the computer and awaits for a password to be input
------------------
This program is open-source, you can use, modify, copy
and enhance this code to your heart's desire.
************************************************/
#include <windows.h>
#include "resource.h"

// Global variables
HWND theMainWindow;
HINSTANCE theMainInstance;

// Global functions
BOOL CALLBACK mainDlgProc(HWND theWnd, UINT theMsg, WPARAM wParam, LPARAM lParam);
void LockPC();
void UnLock();
char AboutUs[] = "2000 Chaplin Corp. http://www.angelfire.com/id/chaplincorp";


// Entry function
int WINAPI WinMain(HINSTANCE theInstance, HINSTANCE prevInstance, LPSTR CLine, int CShow)
{
	// This makes sure only one instance of PcLock is running
	HANDLE theMutex = CreateMutex(NULL, FALSE, "ChaplinComputerLock");
	if ((!theMutex) || (GetLastError() == ERROR_ALREADY_EXISTS))
	{
		// Already running
		return 1;
	}
	theMainInstance = theInstance;
	// Create the window that will cover the screen
	DialogBox(theInstance, MAKEINTRESOURCE(IDD_DIALOG1), NULL, mainDlgProc);
	// Free the mutex
	ReleaseMutex(theMutex);
	return 0;
}

BOOL CALLBACK mainDlgProc(HWND theWnd, UINT theMsg, WPARAM wParam, LPARAM lParam)
{
	switch (theMsg)
	{
	case WM_INITDIALOG:
		{
			theMainWindow = theWnd;
			// Enable the timer that periodically sets the window to be topmost
			SetTimer(theWnd, 1, 1, NULL);
			// Lock the pc
			LockPC();
			
		}break;
	case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
			// Button was pressed, this is also called when
			// the user presses enter since it's the default button
			case IDC_UNLOCK: UnLock(); break;
			}
		}break;
	case WM_TIMER:
		{
			// Little protection in case another topmost window appears on top of PCLOCK
			// This is done every second
			int Xsize, Ysize;
			Xsize = GetSystemMetrics(SM_CXSCREEN);
			Ysize = GetSystemMetrics(SM_CYSCREEN);
			SetWindowPos(theMainWindow, HWND_TOPMOST, 0, 0, Xsize, Ysize, SWP_SHOWWINDOW);
		} break;
	default: return FALSE;
	}
	return TRUE;
}

void LockPC()
{
	// Scale the dialog to fill the entire screen
	int Xsize, Ysize;
	Xsize = GetSystemMetrics(SM_CXSCREEN);
	Ysize = GetSystemMetrics(SM_CYSCREEN);
	SetWindowPos(theMainWindow, HWND_TOPMOST, 0, 0, Xsize, Ysize, SWP_SHOWWINDOW);
	// Center the text box
	HWND temp = GetDlgItem(theMainWindow, IDC_PASSWORD);
	SetWindowPos(temp, HWND_TOP, Xsize/2-50, Ysize/2, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	// Move the button offscreen (Looks better without it)
	temp = GetDlgItem(theMainWindow, IDC_UNLOCK);
	SetWindowPos(temp, HWND_TOP, -50, -50, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	// Disable Alt-Tab, WinKey, Ctrl-Alt-Del, Etc...
	SystemParametersInfo(SPI_SCREENSAVERRUNNING, 1, 0, 0);
	// All mouse messages to this dialog
	SetCapture(theMainWindow);
}

void UnLock()
{
	// Check if the password is correct
	char* password = "chaplin";
	char buff[500];
	int len = GetDlgItemText(theMainWindow, IDC_PASSWORD, buff, 500);
	for (int i=0; i<lstrlen(password); i++)
		if (password[i] != buff[i])
			return;
	// If it is, kill the timer
	KillTimer(theMainWindow, 1);
	// Enable the controls keys back
	SystemParametersInfo(SPI_SCREENSAVERRUNNING, 0, 0, 0);
	// Close the dialog
	EndDialog(theMainWindow, 1);
}