#ifndef _CELLTYPE_
#define _CELLTYPE_

#define colRGB(r, g ,b)  ((unsigned long) (((char) (r) | ((int) (g) << 8)) | (((unsigned long) (char) (b)) << 16)))
#define L_EMPTY	0
#define L_FOOD	1
#define L_CELL	2

class CELLTYPE
{
public:
	//the cell's coordinates
	unsigned int m_x, m_y;
	//its internal energy
	char m_energy;
	//its race, this is currently not implemented
	char m_race;
	//a pointer to the next cell in the queue
	CELLTYPE *m_nextcell;
	//a pointer to the previous cell in the queue
	CELLTYPE *m_parent;
	//the constructor
	CELLTYPE (char c_energy,
		char c_state,
		CELLTYPE *c_parent,
		int c_x,
		int c_y);
	//the destructor
	~CELLTYPE();
};

//used to save information on the CellGrid
struct GRIDSTATE
{
	unsigned char type;
	unsigned long* data;
	unsigned char energy;
};


//the main class which takes care of everything
class CELLMAP
{
public:
	unsigned long m_foodNum;		//number of active food
	unsigned long m_cellNum;		//number of active cells
	unsigned long m_deadFood;		//number of dead food
	unsigned long m_deadCell;		//number of dead cells
	unsigned long m_foodgrown;		//amount of food grown each cycle
	
	unsigned long m_cellvitality;	//how long cells can last without eating
	unsigned long m_cellspeed;		//chances of wait states

	long m_width;					//width of the grid
	long m_height;					//height of the grid
	GRIDSTATE *m_cellgrid;			//an array of GRIDSTATE
	unsigned long *m_colorgrid;		//a pointer to the color table
	CELLTYPE *m_cell;				//the master cell, head of the queue
	//constructor
	CELLMAP (unsigned long w,
		unsigned long h,
		int nfood,
		int foodgrown,
		int ncell,
		unsigned long cellvitality,
		unsigned long cellspeed,
		int seed);
	//destructor
	~CELLMAP();
	//returns the type of the object at (x, y)
	unsigned char GetGridType(int x, int y);
	//sets the type on the grid at (x, y)
	void SetGridType(int x, int y, GRIDSTATE gstate);
	//the food cycle, this is called by the programmer
	void FoodCycle();
	//the cell cycle, this is called by the programmer
	void CellCycle();
	//makes sure the coordinates are in the map
	void AdjustXY(int &x, int &y);
	//grows food at a specific location
	void GrowFood(int x, int y);
};

#endif