/************************************
Copyright Chaplin Corp. 1999

A front end for the CellGrow algorithm
in Win32 using standard GDI calls.

Must be in 32bit colors to see the animation
*************************************/

#include <windows.h>
#include <stdlib.h>
#include "celltype.h"

#define TIMERID		1001
#define MAPX		320
#define MAPY		200

unsigned char num = 10;
HINSTANCE theMainInstance;
HWND theMainWindow;
bool start = false;

CELLMAP *cellmap;


LRESULT CALLBACK MainWndProc(HWND theWnd, UINT theMsg, WPARAM wParam, LPARAM lParam);
int num2str(char* buffer, int n);


int WINAPI WinMain(HINSTANCE hInst, HINSTANCE prev, LPSTR cmd, int show)
{
	theMainInstance = hInst;

	WNDCLASS wc;
	wc.style			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= (WNDPROC)MainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= theMainInstance;
	wc.hIcon			= NULL;
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH)CreateSolidBrush(RGB(0, 0, 0));
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= "Life Simulator";

	RegisterClass(&wc);

	theMainWindow = CreateWindow("Life Simulator", "Life", WS_VISIBLE | WS_OVERLAPPEDWINDOW, //WS_CAPTION | WS_SYSMENU | WS_THICKFRAME,
		100, 100, 320, 280, NULL, NULL, theMainInstance, NULL);

	MSG msg;
	while(msg.message != WM_QUIT)
	{
		if (PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return 0;
}


LRESULT CALLBACK MainWndProc(HWND theWnd, UINT theMsg, WPARAM wParam, LPARAM lParam)
{
	switch (theMsg)
	{
	case WM_CREATE:
		{
			SetTimer(theWnd, TIMERID, 1, NULL);
			cellmap = new CELLMAP(MAPX, //map width
				MAPY,					//map height
				53000,					//amount of starting food
				300,					//amount of food grown per cycle
				8,						//amount of starting cells
				1,						//cell vitality
				1,						//cell speed
				10);						//seed used for the random number generator
			theMainWindow = theWnd;
			start = true;
		} break;
	case WM_TIMER:
		{
			KillTimer(theWnd, TIMERID);
			cellmap->FoodCycle();
			cellmap->CellCycle();
			InvalidateRect(theWnd, NULL, FALSE);
			SetTimer(theWnd, TIMERID, 1, NULL);
		} break;
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC dc = BeginPaint(theWnd, &ps);

			HBITMAP bmp = NULL;
			HDC bmpDC = NULL;
			bmp = CreateBitmap(MAPX, MAPY, 1, 32, cellmap->m_colorgrid);
			bmpDC = CreateCompatibleDC(dc);
			SelectObject(bmpDC, bmp);
			RECT rect;
			GetWindowRect(theWnd, &rect);

			StretchBlt(dc, 0, 0, rect.right-rect.left, rect.bottom-rect.top, 
				bmpDC, 0, 0, cellmap->m_width, cellmap->m_height,
				SRCCOPY);
				
			DeleteDC(bmpDC);
			DeleteObject(bmp);
/**** THIS IS THE DEBUG INFO, COMPILE WITH THIS TO SHOW THE CELLMAP STATS
/*			char buff[250]; ZeroMemory(buff, 250);
			char *pbuff = buff;
			lstrcat(pbuff, "Cells:"); pbuff+=6;
			pbuff += num2str(pbuff, cellmap->m_cellNum);
			lstrcat(pbuff, " Foods:"); pbuff+=7;
			pbuff += num2str(pbuff, cellmap->m_foodNum);
			lstrcat(pbuff, " Dead Cells:"); pbuff+=12;
			pbuff += num2str(pbuff, cellmap->m_deadCell);
			lstrcat(pbuff, " Dead Foods:"); pbuff+=12;
			pbuff += num2str(pbuff, cellmap->m_deadFood);

			TextOut(dc, 0, 0, buff, lstrlen(buff));

			EndPaint(theWnd, &ps);
*/			
		} break;
	case WM_CLOSE:
		{
			KillTimer(theWnd, TIMERID);
			delete cellmap;
			DestroyWindow(theWnd);
		} break;
	case WM_DESTROY:
		{
			DefWindowProc(theWnd, theMsg, wParam, lParam);
			PostQuitMessage(0);
		};
     default: return( DefWindowProc(theWnd, theMsg, wParam, lParam));

	}
	return 0;
}

int num2str(char* buffer, int n)
{
	int size = 1, power = 10;
	while ((n % power) != n)
	{
		power *= 10;
		size++;
	}
	buffer+=(size-1);
	char num[11] = "0123456789";
	do
	{
		*buffer = num[n % 10];
		buffer--;
		n = (n - (n % 10)) / 10;
	}while (n > 0);
	return size;
}
