/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
import java.awt.*;
import java.util.*;

public class StrangeWorld extends Observable
{
	public StrangeCreature newCreature;
	private int width;
	private int height;
//	private LinkedList list;
	private LinkedList list;
	private int foodGrowTimer = 0;
	
	public StrangeWorld(int width, int height)
	{
		this.width = width;
		this.height = height;
		list = new LinkedList();
		newCreature = null;
	}
	
	public void addCreature(StrangeCreature creature)
	{
		list.add(creature);
		creature.setWorld(this);
	}

	public int getWidth()
	{
		return width;
	}
	
	public int getHeight()
	{
		return height;
	}
	
	public Iterator getCreatureIterator()
	{
		return list.listIterator(0);
	}
	
	public Color getColor(int x, int y, StrangeCreature ignore)
	{
		ListIterator it = (ListIterator)getCreatureIterator();
		int r = 0, g = 0, b = 0;
		int tr, tg, tb;
		int cx = ignore.getX();
		int cy = ignore.getY();
		while (it.hasNext())
		{
			StrangeCreature c = (StrangeCreature)(it.next());
			if (c != ignore)
			{
				int distance = dist(c.getX(), c.getY(), x, y);
				if (distance < StrangeCreature.VIEW_WIDTH)
				{
					// Since the VIEW_WIDTH is 50 then, 5*50 = 250
					// A creature at the edge of sensors is barely
					// visible.
					distance = dist(c.getX(), c.getY(), cx, cy);
					tr = c.getColor().getRed() - (int)(distance * 2.5);
					tg = c.getColor().getGreen() - (int)(distance * 2.5);
					tb = c.getColor().getBlue() - (int)(distance * 2.5);

					r += (tr > 0 ? tr : 0);
					g += (tg > 0 ? tg : 0);
					b += (tb > 0 ? tb : 0);
				}
			}
		}
		if (r > 255) r = 255;
		if (g > 255) g = 255;
		if (b > 255) b = 255;
//		System.out.println(new Color(r, g, b));
		return (new Color(r, g, b));
	}
	
	public void tick()
	{
		if (newCreature != null)
		{
			addCreature(newCreature);
			newCreature = null;
		}
		
		Object[] arr = list.toArray();
		for (int i = 0; i < arr.length; ++i)
		{
			((StrangeCreature)arr[i]).tick();
		}
		for (int i = 0; i < arr.length; ++i)
			if (((StrangeCreature)arr[i]).getHealth() <= 0 && StrangeCreature.selectedOne != (StrangeCreature)arr[i])
				list.remove(((StrangeCreature)arr[i]));
		
		if (++foodGrowTimer > 1)
		{
			foodGrowTimer = 0;
			addCreature(new StrangeFood());
		}
		
		if (StrangePredator.PREDATOR_COUNT == 0)
		{
			StrangeGeneCollection geneCol = new
				StrangeGeneCollection(StrangePredator.eliteGene);
			StrangePredator c = new StrangePredator(geneCol);
			c.move(250, 250);
			addCreature(c);

			geneCol = new
				StrangeGeneCollection(StrangePredator.eliteGene);
			c = new StrangePredator(geneCol);
			c.move(150, 150);
			addCreature(c);

			geneCol = new
				StrangeGeneCollection(StrangePredator.eliteGene);
			c = new StrangePredator(geneCol);
			c.move(50, 50);
			addCreature(c);

			geneCol = new
				StrangeGeneCollection(StrangePredator.eliteGene);
			c = new StrangePredator(geneCol);
			c.move(250, 150);
			addCreature(c);
		}
		if (StrangePrey.PREY_COUNT == 0)
		{
			StrangeGeneCollection geneCol = new
				StrangeGeneCollection(StrangePrey.eliteGene);
			StrangePrey c = new StrangePrey(geneCol);
			c.move(250, 250);
			addCreature(c);

			geneCol = new
				StrangeGeneCollection(StrangePrey.eliteGene);
			c = new StrangePrey(geneCol);
			c.move(150, 150);
			addCreature(c);

			geneCol = new
				StrangeGeneCollection(StrangePrey.eliteGene);
			c = new StrangePrey(geneCol);
			c.move(50, 50);
			addCreature(c);

			geneCol = new
				StrangeGeneCollection(StrangePrey.eliteGene);
			c = new StrangePrey(geneCol);
			c.move(250, 150);
			addCreature(c);
		}
		setChanged();
		notifyObservers();
		
	}
	
	public int creatureCount()
	{
		return list.size();
	}
	
	public int dist(int x1, int y1, int x2, int y2)
	{
		int dx = x2 - x1;
		int dy = y2 - y1;
		int distance = MathAccel.sqrt(dx * dx + dy * dy) + 1;
//System.out.println("Distance = " + distance);
		return distance;
	}
	
	public StrangeCreature checkContact(int x, int y, StrangeCreature ignore, int width)
	{
		ListIterator it = (ListIterator)getCreatureIterator();
		while (it.hasNext())
		{
			StrangeCreature c = (StrangeCreature)(it.next());
			if (c != ignore)
			{
				int cx =c.getX(), cy = c.getY();
				if ((cx >= (x - width)) &&
					(cx <= (x + width)) &&
					(cy >= (y - width)) &&
					(cy <= (y + width)))
				{
					int distance = dist(cx, cy, x, y);
					if (distance <= width)
					{
						return c;
					}
				}
			}
		}
		return null;
	}
	
	public int wrapX(int x)
	{
		if (x < 0)
			x += width;
		else if (x >= width)
			x %= width;
		return x;
	}
	
	public int wrapY(int y)
	{
		if (y < 0)
			y += height;
		else if (y >= height)
			y %= height;
		return y;
	}
	
	public LinkedList getList()
	{
		return list;
	}
}
