/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
import java.awt.*;
public class StrangePrey extends StrangeCreature
{
	public static StrangeGeneCollection eliteGene;
	public static double averageAge = 0;
	public static int deathCount = 0;
	public static Color PREY_COLOR = new Color(0, 0, 255);
	public static int PREY_COUNT = 0;
	
	public StrangePrey(StrangeGeneCollection aGene)
	{
		super(PREY_COLOR, aGene);
		this.foodChainLevel = 1;
		++PREY_COUNT;
	}
	
	public void reproduce()
	{
		StrangeGeneCollection g;
		StrangePrey c;
		
		g = new StrangeGeneCollection(geneCollection);
		if (eliteGene != null && elitism)
			g.merge(eliteGene);
		g.mutate();
		c = new StrangePrey(g);
		c.move(x + 10, y);
		world.addCreature(c);
		
		g = new StrangeGeneCollection(geneCollection);
		if (eliteGene != null && elitism)
			g.merge(eliteGene);
		g.mutate();
		c = new StrangePrey(g);
		c.move(x + -10, y);
		world.addCreature(c);
	}
	
	public void die()
	{
		if (age > averageAge && elitism)
		{
			averageAge = (averageAge * deathCount + age) / (++deathCount);
			System.out.println("Average age for prey is : " + averageAge);
			eliteGene = geneCollection;
		}
		else if (!elitism)
			eliteGene = geneCollection;
		
	}

	public boolean isEdible(StrangeCreature c)
	{
		int level = c.getFoodChainLevel();
		if (level == (foodChainLevel - 1))
			return true;
		return false;
	}
	
	public void finalize()
	{
		System.out.println("Prey count:" + PREY_COUNT);
		--PREY_COUNT;
	}
	
}
