/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
import java.awt.*;
public class StrangePredator extends StrangeCreature
{
	public static StrangeGeneCollection eliteGene;
	public static double averageAge = 0;
	public static int deathCount = 0;
	public static Color PREDATOR_COLOR = new Color(255, 0, 0);
	public static int PREDATOR_COUNT = 0;
	
	private int eatCount;
	
	public StrangePredator(StrangeGeneCollection aGene)
	{
		super(PREDATOR_COLOR, aGene);
		this.foodChainLevel = 2;
		eatCount = 0;
		++PREDATOR_COUNT;
	}
	
	public void reproduce()
	{
		if (++eatCount > 9)
		{
			StrangeGeneCollection geneCol = new
				StrangeGeneCollection(geneCollection);
			if (eliteGene != null && elitism)
				geneCol.merge(eliteGene);
			geneCol.mutate();
			StrangePredator c = new StrangePredator(geneCol);
			c.move(x + 15, y);
			world.addCreature(c);
			
			geneCol = new StrangeGeneCollection(geneCollection);
			if (eliteGene != null && elitism)
				geneCol.merge(eliteGene);
			geneCol.mutate();
			c = new StrangePredator(geneCol);
			c.move(x - 15, y);
			world.addCreature(c);
			
			geneCol = new StrangeGeneCollection(geneCollection);
			if (eliteGene != null && elitism)
				geneCol.merge(eliteGene);
			geneCol.mutate();
			c = new StrangePredator(geneCol);
			c.move(x, y + 15);
			world.addCreature(c);
			
			eatCount = 0;
		}
	}
	
	public void die()
	{
		if (age > averageAge && elitism)
		{
			averageAge = (averageAge * deathCount + age) / (++deathCount);
			System.out.println("Average age for predator is : " + averageAge);
			eliteGene = geneCollection;
		}
		else if (!elitism)
			eliteGene = geneCollection;
	}
	
	public boolean isEdible(StrangeCreature c)
	{
		int level = c.getFoodChainLevel();
		if (level == foodChainLevel || level == (foodChainLevel - 1))
			return true;
		return false;
	}
	
	public void finalize()
	{
		System.out.println("Predator count:" + PREDATOR_COUNT);
		--PREDATOR_COUNT;
	}
}
