/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
public class StrangeNeuron
{
	public static int SIGNAL_MAX = 1000;
	public static int SIGNAL_MIN = -1000;
	
	public int bias[];
	public int biasAvg;
	public int currentS;
	public int lastS;
//	public int newS;

	public StrangeNeuron(int bias[])
	{
		this.bias = new int[bias.length];
		biasAvg = 0;
		for (int i = 0; i < bias.length; ++i)
		{
			this.bias[i] = bias[i];
			biasAvg += bias[i];
		}
		biasAvg /= bias.length;
//System.out.println("Bias = " + biasAvg);
		currentS = 0;
		lastS = 0;
		
//		newS = 0;
	}
	
	public void push(int value)
	{
		currentS = value;
	}
	
	public int pop()
	{
		return currentS;
	}

/*	public void update()
	{
		currentS = newS;
	}
*/
	public void tick(StrangeNeuron[] neuronArray)
	{
		lastS = currentS;
		currentS = 0;
		for (int i = 0; i < neuronArray.length; ++i)
		{
			currentS += neuronArray[i].pop() * bias[i];
		}
		currentS += lastS * bias[bias.length - 1];
		if (biasAvg != 0)
			currentS /= bias.length * biasAvg;
		else
			currentS /= bias.length;
		if (currentS > SIGNAL_MAX)
			currentS = SIGNAL_MAX;
		else if (currentS < SIGNAL_MIN)
			currentS = SIGNAL_MIN;
	}
}
