/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
import java.io.*;

public class StrangeNNGene implements StrangeGene
{
	public static int DEFAULT_INPUT_COUNT = 9;
	public static int DEFAULT_LAYER_COUNT = 5;
	
	public static int MUTATE_RATE = 3;

	private int gene[][][];
	private int layerCount;
	private int inputCount;
	
	// Builds a gene from another gene
	public StrangeNNGene(StrangeNNGene aGene)
	{
		layerCount = aGene.getLayerCount();
		inputCount = aGene.getInputCount();
		gene = new int[layerCount][inputCount][inputCount + 1];
		for (int l = 0; l < layerCount; ++l)
		{
			for (int i = 0; i < inputCount; ++i)
			{
				int bias[] = aGene.getBias(l, i);
				for (int b = 0; b < inputCount + 1; ++b)
					gene[l][i][b] = bias[b];
			}
		}
	}
	
	// Builds a random gene
	public StrangeNNGene()
	{
		this.layerCount = DEFAULT_LAYER_COUNT;
		this.inputCount = DEFAULT_INPUT_COUNT;
		
		gene = new int[layerCount][inputCount][inputCount + 1];
		for (int l = 0; l < layerCount; ++l)
			for (int i = 0; i < inputCount; ++i)
				for (int b = 0; b < inputCount + 1; ++b)
					gene[l][i][b] = (int)(Math.random() *
					StrangeNeuron.SIGNAL_MAX * 2) -
					StrangeNeuron.SIGNAL_MAX;
	}
	
	public StrangeNNGene(String filename)
	{
				byte[] buff = new byte[4];
		try
		{
			FileInputStream fw = new FileInputStream(filename);
			fw.read(buff);
			layerCount = (((int)buff[2]) << 8) + ((int)buff[3]);
System.out.println("LayerCount = " + layerCount);
			fw.read(buff);
			inputCount = (((int)buff[2]) << 8) + ((int)buff[3]);
System.out.println("inputCount = " + inputCount);
			gene = new int[layerCount][inputCount][inputCount + 1];
			for (int l = 0; l < layerCount; ++l)
				for (int i = 0; i < inputCount; ++i)
					for (int b = 0; b < inputCount + 1; ++b)
					{
						fw.read(buff);
						gene[l][i][b] =
							(((int)(buff[0]) & 0x000000ff) << 24) |
							(((int)(buff[1]) & 0x000000ff) << 16) |
							(((int)(buff[2]) & 0x000000ff) << 8) |
							((int)(buff[3] & 0x000000ff));
					}
			fw.close();
		}
		catch (Exception e)
		{
System.out.println("Error reading gene : " + filename);
System.out.println("Generating random gene");
			this.layerCount = DEFAULT_LAYER_COUNT;
			this.inputCount = DEFAULT_INPUT_COUNT;
			gene = new int[layerCount][inputCount][inputCount + 1];
			for (int l = 0; l < layerCount; ++l)
				for (int i = 0; i < inputCount; ++i)
					for (int b = 0; b < inputCount + 1; ++b)
					{
						gene[l][i][b] = (int)(Math.random() *
						StrangeNeuron.SIGNAL_MAX * 2) -
						StrangeNeuron.SIGNAL_MAX;
						if (gene[l][i][b] > StrangeNeuron.SIGNAL_MAX)
							gene[l][i][b] = StrangeNeuron.SIGNAL_MAX;
						if (gene[l][i][b] < StrangeNeuron.SIGNAL_MIN)
							gene[l][i][b] = StrangeNeuron.SIGNAL_MIN;
					}
		 }
	}
	
	public boolean saveTo(String filename)
	{
			byte[] buff = new byte[2];
		buff[0] = buff[1] = 0;
		try
		{
			FileOutputStream fw = new FileOutputStream(filename);
			fw.write(buff); fw.write(layerCount >> 8); fw.write(layerCount);
			fw.write(buff); fw.write(inputCount >> 8); fw.write(inputCount);
			for (int l = 0; l < layerCount; ++l)
				for (int i = 0; i < inputCount; ++i)
					for (int b = 0; b < inputCount + 1; ++b)
					{
System.out.println("Bias for ["+l+"]["+i+"]["+b+"] = " + (gene[l][i][b]));
						fw.write((gene[l][i][b] >> 24) & 0x000000ff);
						fw.write((gene[l][i][b] >> 16) & 0x000000ff);
						fw.write((gene[l][i][b] >> 8) & 0x000000ff);
						fw.write((gene[l][i][b]) & 0x000000ff);
					}
			fw.flush();
			fw.close();
		}
		 catch (Exception e) {}
		 return true;
	}
	
	public int[] getBias(int layer, int input)
	{
		return gene[layer][input];
	}
	
	public int getInputCount()
	{
		return inputCount;
	}
	
	public int getLayerCount()
	{
		return layerCount;
	}

	public void mutate()
	{
			int l, i, b;
			l = (int)(Math.random() * layerCount);
			i = (int)(Math.random() * inputCount);
			b = (int)(Math.random() * (inputCount + 1));
			if (gene[l][i][b] > StrangeNeuron.SIGNAL_MIN)
				gene[l][i][b]--;
				
			l = (int)(Math.random() * layerCount);
			i = (int)(Math.random() * inputCount);
			b = (int)(Math.random() * (inputCount + 1));
			if (gene[l][i][b] < StrangeNeuron.SIGNAL_MAX)
				gene[l][i][b]++;

		if ((int)(Math.random() * 10) == 1)
		{
			l = (int)(Math.random() * layerCount);
			i = (int)(Math.random() * inputCount);
			b = (int)(Math.random() * (inputCount + 1));
			int newVal = (int)((Math.random() * StrangeNeuron.SIGNAL_MAX * 2) -
				StrangeNeuron.SIGNAL_MAX);
			if (newVal > StrangeNeuron.SIGNAL_MAX)
				newVal = StrangeNeuron.SIGNAL_MAX;
			else if (newVal < StrangeNeuron.SIGNAL_MIN)
				newVal = StrangeNeuron.SIGNAL_MIN;
			gene[l][i][b] = newVal;
				
		}
	}
	
	public void merge(StrangeGene aGene)
	{
		merge((StrangeGene)aGene);
	}
	
	public void merge(StrangeNNGene aGene)
	{
		int layer, neuron, bias;
		// Merge half of the values
		int amount = (layerCount * inputCount * (inputCount + 1)) / 2;
		for (int i = 0; i < amount; ++i)
		{
			layer = (int)(Math.random() * layerCount);
			neuron = (int)(Math.random() * inputCount);
			bias = (int)(Math.random() * (inputCount + 1));
			gene[layer][neuron][bias] =
				aGene.getBias(layer, neuron)[bias];
		}
	}
}
