/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
public class StrangeNN
{
	
	private StrangeNeuron nn[][];
	private int inputCount;
	private int layerCount;
	
	public StrangeNN(StrangeNNGene gene)
	{
		layerCount = gene.getLayerCount();
		inputCount = gene.getInputCount();
		nn = new StrangeNeuron[layerCount][inputCount];
		for (int l = 0; l < layerCount; ++l)
			for (int i = 0; i < inputCount; ++i)
				nn[l][i] = new StrangeNeuron(gene.getBias(l, i));
		
	}
	
	public void push(int index, int value)
	{
		nn[0][index].push(value);
	}
	
	public int pop(int index)
	{
		return nn[layerCount-1][index].pop();
	}

	public void tick()
	{
//		System.out.println(this);
		for (int i = 1; i < layerCount; ++i)
			for (int j = 0; j < inputCount; ++j)
				nn[i][j].tick(nn[i-1]);
	}
	
	public String toString()
	{
		String temp = "";
		
		for (int i = 0; i < layerCount; ++i)
		{
			for (int j = 0; j < inputCount; ++j)
				temp += nn[i][j].pop() + "\t";
			temp += "\n";
		}
		return temp;
	}
}
