/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
import java.awt.*;
//import java.awt.event.*;
import java.util.*;
//import javax.swing.*;

public abstract class StrangeCreature extends StrangeObject
{
	public static int MAX_HEALTH = 1000;
	public static int CREATURE_WIDTH = 10;
	public static int TAIL_LENGTH = 15;
	public static int VIEW_RANGE = 50;
	public static int VIEW_WIDTH = 50;
	public static int STEP_LEVEL = 100;
	// Neural network input addresses
	private static final int NNI_R1 = 0;		// Red 1
	private static final int NNI_G1 = 1;		// Green 1
	private static final int NNI_B1 = 2;		// Blue 1
	private static final int NNI_R2 = 3;		// Red 2
	private static final int NNI_G2 = 4;		// Green 2
	private static final int NNI_B2 = 5;		// Blue 2
	private static final int NNI_H = 6;			// Health
	private static final int NNI_R = 7;			// Last Rotation
	private static final int NNI_F = 8;			// Last Forward
	// Neural network output addresses
	private static final int NNO_F = 0;			// Forward
	private static final int NNO_R = 1;			// Rotation
	
	// These variables can be changed at runtime
	public static boolean renderView = false;
	public static boolean vectorDraw = false;
	public static boolean elitism = false;
	public static boolean healthView = true;
	public static boolean wireframe = true;
	public static StrangeCreature selectedOne = null;
	
	// Angle the creature is facing
	protected int angle;
	
	protected int xLevel;
	protected int yLevel;
	protected int angleLevel;
	
	protected int health;
	protected int reproductiveLevel;
	protected StrangeNN brain;
	protected StrangeGeneCollection geneCollection;
	protected StrangeWorld world;
	protected int foodChainLevel;
	protected int age;
	
	public StrangeCreature(Color color, StrangeGeneCollection geneCollection)
	{
		super(-1, -1, color);
		this.health = (int)(Math.random() * MAX_HEALTH);
		this.angle = (int)(Math.random() * 360);
		this.xLevel = 0;
		this.yLevel = 0;
		this.angleLevel = 0;
		this.reproductiveLevel = 0;
		this.geneCollection = geneCollection;
		if (geneCollection != null)
			if (geneCollection.getNNGene() != null)
				this.brain = new StrangeNN(geneCollection.getNNGene());
			else
				this.brain = null;
		this.foodChainLevel = 0;
		this.age = 0;
	}
	
	public void setWorld(StrangeWorld w)
	{
		world = w;
		if (x == -1)
			x = (int)(Math.random() * world.getWidth());
		if (y == -1)
			y = (int)(Math.random() * world.getHeight());
	}
	
	public int getHealth()
	{
		return health;
	}
	
	public void tick()
	{
		// The selected one does not did
		if (selectedOne == this)
			health = MAX_HEALTH;
		--health;
		if (health <= 0)
		{
			die();
			return;
		}
		++age;
		brain.tick();
		processOutputs();
		processInputs();
		processOther();
	}
	
	public void draw(Graphics g)
	{
		if (health > MAX_HEALTH)
			health = MAX_HEALTH;
		else if (health < 0)
			health = 0;
		if (selectedOne == this)
			// If this creature is selected, color is yellow
			g.setColor(new Color(255, 255, 0));
		else if (healthView)
		{
			int rcol = (int)(health / 4 + 100 > 255 ? 255 : health / 4 + 100);
			g.setColor(new Color((color.getRed() > 0 ? rcol : 0),
				  (color.getGreen() > 0 ? rcol : 0),
				  (color.getBlue() > 0 ? rcol : 0)));
		}
		else
			g.setColor(color);
		if (!vectorDraw)
			if (wireframe)
				g.drawOval(x - CREATURE_WIDTH / 2, y - CREATURE_WIDTH / 2, CREATURE_WIDTH, CREATURE_WIDTH);
			else
				g.fillOval(x - CREATURE_WIDTH / 2, y - CREATURE_WIDTH / 2, CREATURE_WIDTH, CREATURE_WIDTH);
		g.drawLine(x, y, (int)(x - MathAccel.cos(angle) * TAIL_LENGTH),
			(int)(y - MathAccel.sin(angle) * TAIL_LENGTH));
		
		if (renderView)
		{
			if (selectedOne == this)
				// If this creature is selected, color is yellow
				g.setColor(new Color(255, 255, 0));
			g.drawOval((int)(x + MathAccel.cos(angle - 45) * VIEW_RANGE - VIEW_WIDTH),
				(int)(y + MathAccel.sin(angle - 45) * VIEW_RANGE - VIEW_WIDTH),
				VIEW_WIDTH * 2, VIEW_WIDTH * 2);
			g.drawOval((int)(x + MathAccel.cos(angle + 45) * VIEW_RANGE - VIEW_WIDTH),
				(int)(y + MathAccel.sin(angle + 45) * VIEW_RANGE - VIEW_WIDTH),
				VIEW_WIDTH * 2, VIEW_WIDTH * 2);
			g.setColor(new Color(0, 0, 0));
			g.fillOval((int)(x + MathAccel.cos(angle - 45) * VIEW_RANGE),
					(int)(y + MathAccel.sin(angle - 45) * VIEW_RANGE), 1, 1);
			g.fillOval((int)(x + MathAccel.cos(angle + 45) * VIEW_RANGE),
					(int)(y + MathAccel.sin(angle + 45) * VIEW_RANGE), 1, 1);
		}
	}
	
	private void processInputs()
	{
		Color colorRight = world.getColor((int)(x + MathAccel.cos(angle - 45) * VIEW_RANGE),
				(int)(y + MathAccel.sin(angle - 45) * VIEW_RANGE), this);
		Color colorLeft = world.getColor((int)(x + MathAccel.cos(angle + 45) * VIEW_RANGE),
				(int)(y + MathAccel.sin(angle + 45) * VIEW_RANGE), this);

		brain.push(NNI_R1, colorRight.getRed());
		brain.push(NNI_G1, colorRight.getGreen());
		brain.push(NNI_B1, colorRight.getBlue());
		brain.push(NNI_R2, colorLeft.getRed());
		brain.push(NNI_G2, colorLeft.getGreen());
		brain.push(NNI_B2, colorLeft.getBlue());
		
		brain.push(NNI_H, health);
		brain.push(NNI_R, brain.pop(NNO_R));
		brain.push(NNI_F, brain.pop(NNO_F));
	}
	
	private void processOutputs()
	{
		int value = brain.pop(NNO_F);
		int pvalue = (value > 0 ? value : value * -1);
		health -= (int)(pvalue / 80);
		// Process the x translation
		xLevel += value * MathAccel.cos(angle);
		while (xLevel > STEP_LEVEL)
		{
			xLevel -= STEP_LEVEL;
			++x;
		}
		while (xLevel < -STEP_LEVEL)
		{
			xLevel += STEP_LEVEL;
			--x;
		}
		
		// Process the y translation
		yLevel += value * MathAccel.sin(angle);
		while (yLevel > STEP_LEVEL)
		{
			yLevel -= STEP_LEVEL;
			++y;
		}
		while (yLevel < -STEP_LEVEL)
		{
			yLevel += STEP_LEVEL;
			--y;
		}
		
		value = brain.pop(NNO_R);
		// Process the rotation
		angleLevel += value;
		while (angleLevel > STEP_LEVEL)
		{
			angleLevel -= STEP_LEVEL;
			++angle;
		}
		while (angleLevel < -STEP_LEVEL)
		{
			angleLevel += STEP_LEVEL;
			--angle;
		}
		
		x = world.wrapX(x);
		y = world.wrapY(y);
		
		if (angle > 360)
			angle -= 360;
		else if (angle < 0)
			angle += 360;
	}
	
	public int getFoodChainLevel()
	{
		return foodChainLevel;
	}
	
	public void kill()
	{
		health = 0;
		die();
	}
	
	private void processOther()
	{
		StrangeCreature c;
		c = world.checkContact(x, y, this, CREATURE_WIDTH);
		if (c != null)
		{
			if (isEdible(c) && c.getHealth() > 0)
			{
				c.kill();
				health += 150;
				reproduce();
			}
		}
	}
	
	public int getAge()
	{
		return age;
	}
	
	public abstract void reproduce();
	
	public abstract void die();
	
	public abstract boolean isEdible(StrangeCreature c);
}
