/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
import java.awt.*;
import java.util.*;
import java.awt.event.*;

public class StrangeController implements Observer, MouseListener, KeyListener
{
	
	private StrangeWorld world;
	private StrangeView view;
	private Color bgCol;
	
	public boolean doRendering = true;
	public boolean renderHigh = false;
	public boolean isPaused = false;
	
	public StrangeController(StrangeWorld world, StrangeView view)
	{
		this.world = world;
		this.view = view;
		doRendering = false;
		view.addMouseListener(this);
		view.addKeyListener(this);
		world.addObserver(this);
		bgCol = new Color(0, 0, 0);
	}
	
	public void keyTyped(KeyEvent e)
	{
		// Switch between rendering quality
		if (e.getKeyChar() == 'h')
		{
            renderHigh = !renderHigh;
			
			Graphics2D g = (Graphics2D)view.getBufferGraphics();
			if (renderHigh)
				g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                    RenderingHints.VALUE_ANTIALIAS_ON);
            else
				g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                    RenderingHints.VALUE_ANTIALIAS_OFF);
			update(null, null);
		}
		// Switch between no rendering
		else if (e.getKeyChar() == 'r')
		{
			doRendering = !doRendering;
		}
		else if (e.getKeyChar() == 'b')
		{
			// Changes the color of the background
			if (bgCol.getRed() > 0)
				bgCol = new Color(0, 0, 0);
			else
				bgCol = new Color(255, 255, 255);
			update(null, null);
		}
		else if (e.getKeyChar() == 'g')
		{
			// Shades the creatures based on their health
			StrangeCreature.healthView = !StrangeCreature.healthView;
			update(null, null);
		}
		else if (e.getKeyChar() == 'l')
		{
			// Renders the creatures as vectors
			StrangeCreature.vectorDraw = !StrangeCreature.vectorDraw;
			update(null, null);
		}
		else if (e.getKeyChar() == 'p')
		{
			// Pauses the world
			isPaused = !isPaused;
		}
		else if (e.getKeyChar() == 'v')
		{
			// Render the field of view
			StrangeCreature.renderView = !StrangeCreature.renderView;
			update(null, null);
		}
		else if (e.getKeyChar() == 'k'/*e.getKeyCode() == e.VK_DELETE*/)
		{
			if (StrangeCreature.selectedOne != null)
				StrangeCreature.selectedOne.health = 0;
		}
		else if (e.getKeyChar() == 'w')
		{
			// Render the field of view
			StrangeCreature.wireframe = !StrangeCreature.wireframe;
			update(null, null);
		}
	}
	
	public void keyPressed(KeyEvent e)
	{
	}
	
	public void keyReleased(KeyEvent e)
	{
	}
	
	public void mouseClicked(MouseEvent e)
	{
		int m = e.getModifiers();
		StrangeCreature c;
		c = world.checkContact(e.getX(), e.getY(), null, StrangeCreature.CREATURE_WIDTH);
		if ((m & e.BUTTON1_MASK) > 0)
		{
			StrangeCreature.selectedOne = c;
			update(null, null);
			/*            renderHigh = !renderHigh;
			
			Graphics2D g = (Graphics2D)view.getBufferGraphics();
			if (renderHigh)
				g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                    RenderingHints.VALUE_ANTIALIAS_ON);
            else
				g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
			 RenderingHints.VALUE_ANTIALIAS_OFF);*/
		}
		else if ((m & e.BUTTON2_MASK) > 0)
		{
			if (bgCol.getRed() > 0)
				bgCol = new Color(0, 0, 0);
			else
				bgCol = new Color(255, 255, 255);
		}
		else if ((m & e.BUTTON3_MASK) > 0)
		{
			//doRendering = !doRendering;
			StrangeGeneCollection geneCol = new
				StrangeGeneCollection(StrangePredator.eliteGene);
			geneCol.mutate();
			StrangePredator pred = new StrangePredator(geneCol);
			pred.move(e.getX(), e.getY());
			world.newCreature = pred;
			
		}
	}

	public void mouseEntered(MouseEvent e)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent e)
	{
	}

	public void mouseReleased(MouseEvent e)
	{
	}

	public void update(Observable observable, Object arg)
	{
		if (!view.isValidImage())
			view.createBufferImage();
		if (doRendering && view.isValidImage())
		{
			Graphics2D g = (Graphics2D)view.getBufferGraphics();

			g.setColor(bgCol);
			g.fillRect(0, 0, view.getWidth(), view.getHeight());

			ListIterator it = (ListIterator)world.getCreatureIterator();
			while (it.hasNext())
			{
				((StrangeCreature)it.next()).draw(g);
			}
			view.repaint();
		}
	}
}
