/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.io.*;

public class StrangeApplication extends JFrame
{
	public static boolean doTick = true;
	public static boolean canClose = false;
		
	public StrangeApplication(String title)
	{
		super(title);
	}
	
	/**
	 * Entry point of the program
	 * @param args An array of command lines.
	 */
	public static void main(String args[])
	{
		boolean noX = false;
		StrangeApplication app = null;
		StrangeView view = null;
		StrangeController controller = null;
        int delay = 2;
		
		// Process all the arguments
		for (int i = 0; i < args.length; ++i)
		{
			if(args[i].equals("NOX"))
				noX = true;
			/*			else if(args[i].equals("vector"))
				StrangeCreature.vectorDraw = true;
			else if(args[i].equals("elitism"))
				StrangeCreature.elitism = true;
			else
			 delay = Integer.parseInt(args[i]);*/
		}
		
		MathAccel.init();
		StrangeWorld world = new StrangeWorld(500, 500);
		
		StrangeGeneCollection geneCol;
		for (int i = 0; i < 30; ++i)
		{
			geneCol = new StrangeGeneCollection();
			geneCol.setNNGene(new StrangeNNGene("predator.gen"));
			world.addCreature(new StrangePredator(geneCol));
		}
			
		for (int i = 0; i < 30; ++i)
		{
			geneCol = new StrangeGeneCollection();
			geneCol.setNNGene(new StrangeNNGene("prey.gen"));
			world.addCreature(new StrangePrey(geneCol));
		}
//		StrangePrey.eliteGene = new StrangeGeneCollection();
//		StrangePredator.eliteGene = new StrangeGeneCollection();
		
		if (!noX)
		{
			app = new StrangeApplication("StrangeWorld - chaplin_hack@hotmail.com");
			view = new StrangeView();
			controller = new StrangeController(world, view);
		
			app.getContentPane().setLayout(new GridLayout(1, 1, 0, 0));

			app.getContentPane().add(view);
		
			app.addWindowListener(new WindowAdapter() {
					public void windowClosing(WindowEvent e)
					{
						canClose = true;
					}
				} );

			app.setBounds(100, 100, 500, 500);
			app.setVisible(true);
		
			view.createBufferImage();
			controller.doRendering = true;
		}
		int ntick = 0;
		int saveClock = 0;
		int gcClock = 0;
		while (doTick)
		{
			if (canClose)
			{
				StrangePrey.eliteGene.getNNGene().saveTo("prey.gen");
				StrangePredator.eliteGene.getNNGene().saveTo("predator.gen");
				System.exit(0);
			}
			if (!controller.isPaused)
			{
				world.tick();
				System.out.println("Tick number : " + ++ntick);
				if (!noX && controller != null)
				if (controller.doRendering)
				{
					try
					{
						Thread.currentThread().sleep(delay);
					}
					catch(InterruptedException e) {}
				}
				if (++gcClock > 250)
				{
					gcClock = 0;
					System.gc();
				}
				if (++saveClock > 5000)
				{
					saveClock = 0;
					StrangePrey.eliteGene.getNNGene().saveTo("prey.gen");
					StrangePredator.eliteGene.getNNGene().saveTo("predator.gen");
				}
			}
		}
		
//		System.exit(0);
	}
	
}
