/********************************
Author: Chaplin
E-mail: chaplin_hack@hotmail.com
********************************/
public class MathAccel
{
	public static double cos[];
	public static double sin[];
	public static double toRad[];
	public static int sqrtTable[];
	
	public static void init()
	{
		cos = new double[360];
		sin = new double[360];
		toRad = new double[360];
		for (int i = 0; i < 360; ++i)
			toRad[i] = Math.toRadians(i);
		for (int i = 0; i < 360; ++i)
			cos[i] = Math.cos(toRad[i]);
		for (int i = 0; i < 360; ++i)
			sin[i] = Math.sin(toRad[i]);
		sqrtTable = new int[1000000];
		for (int i = 0; i < 1000000; ++i)
			sqrtTable[i] = (int)Math.sqrt((double)i);
	}
	
	public static double toRadians(int angle)
	{
		angle = fixAngle(angle);
		return toRad[angle];
	}
	
	public static double sin(int angle)
	{
		angle = fixAngle(angle);
		return sin[angle];
	}
	
	public static double cos(int angle)
	{
		angle = fixAngle(angle);
		return cos[angle];
	}
	
	public static int fixAngle(int angle)
	{
		if (angle >= 360)
			return angle - 360;
		else if (angle < 0)
			return angle + 360;
		return angle;
	}
	
	public static int sqrt(int val)
	{
		//System.out.println("sqrt(" + val + ")");
		return sqrtTable[val];
	}
}
