/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Observable;

public class StrangeWorld
extends Observable {
    public StrangeCreature newCreature;
    private int width;
    private int height;
    private LinkedList list;
    private int foodGrowTimer = 0;

    public StrangeWorld(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.list = new LinkedList();
        this.newCreature = null;
    }

    public void addCreature(StrangeCreature strangeCreature) {
        this.list.add(strangeCreature);
        strangeCreature.setWorld(this);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Iterator getCreatureIterator() {
        return this.list.listIterator(0);
    }

    public Color getColor(int n, int n2, StrangeCreature strangeCreature) {
        ListIterator listIterator = (ListIterator)this.getCreatureIterator();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = strangeCreature.getX();
        int n7 = strangeCreature.getY();
        while (listIterator.hasNext()) {
            int n8;
            StrangeCreature strangeCreature2 = (StrangeCreature)listIterator.next();
            if (strangeCreature2 == strangeCreature || (n8 = this.dist(strangeCreature2.getX(), strangeCreature2.getY(), n, n2)) >= StrangeCreature.VIEW_WIDTH) continue;
            n8 = this.dist(strangeCreature2.getX(), strangeCreature2.getY(), n6, n7);
            int n9 = strangeCreature2.getColor().getRed() - (int)((double)n8 * 2.5);
            int n10 = strangeCreature2.getColor().getGreen() - (int)((double)n8 * 2.5);
            int n11 = strangeCreature2.getColor().getBlue() - (int)((double)n8 * 2.5);
            n3 += n9 > 0 ? n9 : 0;
            n4 += n10 > 0 ? n10 : 0;
            n5 += n11 > 0 ? n11 : 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        return new Color(n3, n4, n5);
    }

    public void tick() {
        StrangeCreature strangeCreature;
        StrangeGeneCollection strangeGeneCollection;
        if (this.newCreature != null) {
            this.addCreature(this.newCreature);
            this.newCreature = null;
        }
        Object[] objectArray = this.list.toArray();
        int n = 0;
        while (n < objectArray.length) {
            ((StrangeCreature)objectArray[n]).tick();
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (((StrangeCreature)objectArray[n2]).getHealth() <= 0 && StrangeCreature.selectedOne != (StrangeCreature)objectArray[n2]) {
                this.list.remove((StrangeCreature)objectArray[n2]);
            }
            ++n2;
        }
        if (++this.foodGrowTimer > 1) {
            this.foodGrowTimer = 0;
            this.addCreature(new StrangeFood());
        }
        if (StrangePredator.PREDATOR_COUNT == 0) {
            strangeGeneCollection = new StrangeGeneCollection(StrangePredator.eliteGene);
            strangeCreature = new StrangePredator(strangeGeneCollection);
            strangeCreature.move(250, 250);
            this.addCreature(strangeCreature);
            strangeGeneCollection = new StrangeGeneCollection(StrangePredator.eliteGene);
            strangeCreature = new StrangePredator(strangeGeneCollection);
            strangeCreature.move(150, 150);
            this.addCreature(strangeCreature);
            strangeGeneCollection = new StrangeGeneCollection(StrangePredator.eliteGene);
            strangeCreature = new StrangePredator(strangeGeneCollection);
            strangeCreature.move(50, 50);
            this.addCreature(strangeCreature);
            strangeGeneCollection = new StrangeGeneCollection(StrangePredator.eliteGene);
            strangeCreature = new StrangePredator(strangeGeneCollection);
            strangeCreature.move(250, 150);
            this.addCreature(strangeCreature);
        }
        if (StrangePrey.PREY_COUNT == 0) {
            strangeGeneCollection = new StrangeGeneCollection(StrangePrey.eliteGene);
            strangeCreature = new StrangePrey(strangeGeneCollection);
            strangeCreature.move(250, 250);
            this.addCreature(strangeCreature);
            strangeGeneCollection = new StrangeGeneCollection(StrangePrey.eliteGene);
            strangeCreature = new StrangePrey(strangeGeneCollection);
            strangeCreature.move(150, 150);
            this.addCreature(strangeCreature);
            strangeGeneCollection = new StrangeGeneCollection(StrangePrey.eliteGene);
            strangeCreature = new StrangePrey(strangeGeneCollection);
            strangeCreature.move(50, 50);
            this.addCreature(strangeCreature);
            strangeGeneCollection = new StrangeGeneCollection(StrangePrey.eliteGene);
            strangeCreature = new StrangePrey(strangeGeneCollection);
            strangeCreature.move(250, 150);
            this.addCreature(strangeCreature);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public int creatureCount() {
        return this.list.size();
    }

    public int dist(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        int n7 = MathAccel.sqrt(n5 * n5 + n6 * n6) + 1;
        return n7;
    }

    public StrangeCreature checkContact(int n, int n2, StrangeCreature strangeCreature, int n3) {
        ListIterator listIterator = (ListIterator)this.getCreatureIterator();
        while (listIterator.hasNext()) {
            int n4;
            StrangeCreature strangeCreature2 = (StrangeCreature)listIterator.next();
            if (strangeCreature2 == strangeCreature) continue;
            int n5 = strangeCreature2.getX();
            int n6 = strangeCreature2.getY();
            if (n5 < n - n3 || n5 > n + n3 || n6 < n2 - n3 || n6 > n2 + n3 || (n4 = this.dist(n5, n6, n, n2)) > n3) continue;
            return strangeCreature2;
        }
        return null;
    }

    public int wrapX(int n) {
        if (n < 0) {
            n += this.width;
        } else if (n >= this.width) {
            n %= this.width;
        }
        return n;
    }

    public int wrapY(int n) {
        if (n < 0) {
            n += this.height;
        } else if (n >= this.height) {
            n %= this.height;
        }
        return n;
    }

    public LinkedList getList() {
        return this.list;
    }
}

