/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class StrangePredator
extends StrangeCreature {
    public static StrangeGeneCollection eliteGene;
    public static double averageAge;
    public static int deathCount;
    public static Color PREDATOR_COLOR;
    public static int PREDATOR_COUNT;
    private int eatCount;

    public StrangePredator(StrangeGeneCollection strangeGeneCollection) {
        super(PREDATOR_COLOR, strangeGeneCollection);
        this.foodChainLevel = 2;
        this.eatCount = 0;
        ++PREDATOR_COUNT;
    }

    public void reproduce() {
        if (++this.eatCount > 9) {
            StrangeGeneCollection strangeGeneCollection = new StrangeGeneCollection(this.geneCollection);
            if (eliteGene != null && StrangeCreature.elitism) {
                strangeGeneCollection.merge(eliteGene);
            }
            strangeGeneCollection.mutate();
            StrangePredator strangePredator = new StrangePredator(strangeGeneCollection);
            strangePredator.move(this.x + 15, this.y);
            this.world.addCreature(strangePredator);
            strangeGeneCollection = new StrangeGeneCollection(this.geneCollection);
            if (eliteGene != null && StrangeCreature.elitism) {
                strangeGeneCollection.merge(eliteGene);
            }
            strangeGeneCollection.mutate();
            strangePredator = new StrangePredator(strangeGeneCollection);
            strangePredator.move(this.x - 15, this.y);
            this.world.addCreature(strangePredator);
            strangeGeneCollection = new StrangeGeneCollection(this.geneCollection);
            if (eliteGene != null && StrangeCreature.elitism) {
                strangeGeneCollection.merge(eliteGene);
            }
            strangeGeneCollection.mutate();
            strangePredator = new StrangePredator(strangeGeneCollection);
            strangePredator.move(this.x, this.y + 15);
            this.world.addCreature(strangePredator);
            this.eatCount = 0;
        }
    }

    public void die() {
        if ((double)this.age > averageAge && StrangeCreature.elitism) {
            averageAge = (averageAge * (double)deathCount + (double)this.age) / (double)(++deathCount);
            System.out.println("Average age for predator is : " + averageAge);
            eliteGene = this.geneCollection;
        } else if (!StrangeCreature.elitism) {
            eliteGene = this.geneCollection;
        }
    }

    public boolean isEdible(StrangeCreature strangeCreature) {
        int n = strangeCreature.getFoodChainLevel();
        return n == this.foodChainLevel || n == this.foodChainLevel - 1;
    }

    public void finalize() {
        System.out.println("Predator count:" + PREDATOR_COUNT);
        --PREDATOR_COUNT;
    }

    static {
        averageAge = 0.0;
        deathCount = 0;
        PREDATOR_COLOR = new Color(255, 0, 0);
        PREDATOR_COUNT = 0;
    }
}

