/*
 * Decompiled with CFR 0.152.
 */
public class StrangeNeuron {
    public static int SIGNAL_MAX = 1000;
    public static int SIGNAL_MIN = -1000;
    public int[] bias;
    public int biasAvg;
    public int currentS;
    public int lastS;

    public StrangeNeuron(int[] nArray) {
        this.bias = new int[nArray.length];
        this.biasAvg = 0;
        int n = 0;
        while (n < nArray.length) {
            this.bias[n] = nArray[n];
            this.biasAvg += nArray[n];
            ++n;
        }
        this.biasAvg /= nArray.length;
        this.currentS = 0;
        this.lastS = 0;
    }

    public void push(int n) {
        this.currentS = n;
    }

    public int pop() {
        return this.currentS;
    }

    public void tick(StrangeNeuron[] strangeNeuronArray) {
        this.lastS = this.currentS;
        this.currentS = 0;
        int n = 0;
        while (n < strangeNeuronArray.length) {
            this.currentS += strangeNeuronArray[n].pop() * this.bias[n];
            ++n;
        }
        this.currentS += this.lastS * this.bias[this.bias.length - 1];
        this.currentS = this.biasAvg != 0 ? (this.currentS /= this.bias.length * this.biasAvg) : (this.currentS /= this.bias.length);
        if (this.currentS > SIGNAL_MAX) {
            this.currentS = SIGNAL_MAX;
        } else if (this.currentS < SIGNAL_MIN) {
            this.currentS = SIGNAL_MIN;
        }
    }
}

