/*
 * Decompiled with CFR 0.152.
 */
public class StrangeNN {
    private StrangeNeuron[][] nn;
    private int inputCount;
    private int layerCount;

    public StrangeNN(StrangeNNGene strangeNNGene) {
        this.layerCount = strangeNNGene.getLayerCount();
        this.inputCount = strangeNNGene.getInputCount();
        this.nn = new StrangeNeuron[this.layerCount][this.inputCount];
        int n = 0;
        while (n < this.layerCount) {
            int n2 = 0;
            while (n2 < this.inputCount) {
                this.nn[n][n2] = new StrangeNeuron(strangeNNGene.getBias(n, n2));
                ++n2;
            }
            ++n;
        }
    }

    public void push(int n, int n2) {
        this.nn[0][n].push(n2);
    }

    public int pop(int n) {
        return this.nn[this.layerCount - 1][n].pop();
    }

    public void tick() {
        int n = 1;
        while (n < this.layerCount) {
            int n2 = 0;
            while (n2 < this.inputCount) {
                this.nn[n][n2].tick(this.nn[n - 1]);
                ++n2;
            }
            ++n;
        }
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.layerCount) {
            int n2 = 0;
            while (n2 < this.inputCount) {
                string = string + this.nn[n][n2].pop() + "\t";
                ++n2;
            }
            string = string + "\n";
            ++n;
        }
        return string;
    }
}

