/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public abstract class StrangeCreature
extends StrangeObject {
    public static int MAX_HEALTH = 1000;
    public static int CREATURE_WIDTH = 10;
    public static int TAIL_LENGTH = 15;
    public static int VIEW_RANGE = 50;
    public static int VIEW_WIDTH = 50;
    public static int STEP_LEVEL = 100;
    private static final int NNI_R1 = 0;
    private static final int NNI_G1 = 1;
    private static final int NNI_B1 = 2;
    private static final int NNI_R2 = 3;
    private static final int NNI_G2 = 4;
    private static final int NNI_B2 = 5;
    private static final int NNI_H = 6;
    private static final int NNI_R = 7;
    private static final int NNI_F = 8;
    private static final int NNO_F = 0;
    private static final int NNO_R = 1;
    public static boolean renderView = false;
    public static boolean vectorDraw = false;
    public static boolean elitism = false;
    public static boolean healthView = true;
    public static boolean wireframe = true;
    public static StrangeCreature selectedOne = null;
    protected int angle;
    protected int xLevel = 0;
    protected int yLevel = 0;
    protected int angleLevel = 0;
    protected int health = (int)(Math.random() * (double)MAX_HEALTH);
    protected int reproductiveLevel = 0;
    protected StrangeNN brain;
    protected StrangeGeneCollection geneCollection;
    protected StrangeWorld world;
    protected int foodChainLevel;
    protected int age;

    public StrangeCreature(Color color, StrangeGeneCollection strangeGeneCollection) {
        super(-1, -1, color);
        this.angle = (int)(Math.random() * 360.0);
        this.geneCollection = strangeGeneCollection;
        if (strangeGeneCollection != null) {
            this.brain = strangeGeneCollection.getNNGene() != null ? new StrangeNN(strangeGeneCollection.getNNGene()) : null;
        }
        this.foodChainLevel = 0;
        this.age = 0;
    }

    public void setWorld(StrangeWorld strangeWorld) {
        this.world = strangeWorld;
        if (this.x == -1) {
            this.x = (int)(Math.random() * (double)this.world.getWidth());
        }
        if (this.y == -1) {
            this.y = (int)(Math.random() * (double)this.world.getHeight());
        }
    }

    public int getHealth() {
        return this.health;
    }

    public void tick() {
        if (selectedOne == this) {
            this.health = MAX_HEALTH;
        }
        --this.health;
        if (this.health <= 0) {
            this.die();
            return;
        }
        ++this.age;
        this.brain.tick();
        this.processOutputs();
        this.processInputs();
        this.processOther();
    }

    public void draw(Graphics graphics) {
        if (this.health > MAX_HEALTH) {
            this.health = MAX_HEALTH;
        } else if (this.health < 0) {
            this.health = 0;
        }
        if (selectedOne == this) {
            graphics.setColor(new Color(255, 255, 0));
        } else if (healthView) {
            int n = this.health / 4 + 100 > 255 ? 255 : this.health / 4 + 100;
            graphics.setColor(new Color(this.color.getRed() > 0 ? n : 0, this.color.getGreen() > 0 ? n : 0, this.color.getBlue() > 0 ? n : 0));
        } else {
            graphics.setColor(this.color);
        }
        if (!vectorDraw) {
            if (wireframe) {
                graphics.drawOval(this.x - CREATURE_WIDTH / 2, this.y - CREATURE_WIDTH / 2, CREATURE_WIDTH, CREATURE_WIDTH);
            } else {
                graphics.fillOval(this.x - CREATURE_WIDTH / 2, this.y - CREATURE_WIDTH / 2, CREATURE_WIDTH, CREATURE_WIDTH);
            }
        }
        graphics.drawLine(this.x, this.y, (int)((double)this.x - MathAccel.cos(this.angle) * (double)TAIL_LENGTH), (int)((double)this.y - MathAccel.sin(this.angle) * (double)TAIL_LENGTH));
        if (renderView) {
            if (selectedOne == this) {
                graphics.setColor(new Color(255, 255, 0));
            }
            graphics.drawOval((int)((double)this.x + MathAccel.cos(this.angle - 45) * (double)VIEW_RANGE - (double)VIEW_WIDTH), (int)((double)this.y + MathAccel.sin(this.angle - 45) * (double)VIEW_RANGE - (double)VIEW_WIDTH), VIEW_WIDTH * 2, VIEW_WIDTH * 2);
            graphics.drawOval((int)((double)this.x + MathAccel.cos(this.angle + 45) * (double)VIEW_RANGE - (double)VIEW_WIDTH), (int)((double)this.y + MathAccel.sin(this.angle + 45) * (double)VIEW_RANGE - (double)VIEW_WIDTH), VIEW_WIDTH * 2, VIEW_WIDTH * 2);
            graphics.setColor(new Color(0, 0, 0));
            graphics.fillOval((int)((double)this.x + MathAccel.cos(this.angle - 45) * (double)VIEW_RANGE), (int)((double)this.y + MathAccel.sin(this.angle - 45) * (double)VIEW_RANGE), 1, 1);
            graphics.fillOval((int)((double)this.x + MathAccel.cos(this.angle + 45) * (double)VIEW_RANGE), (int)((double)this.y + MathAccel.sin(this.angle + 45) * (double)VIEW_RANGE), 1, 1);
        }
    }

    private void processInputs() {
        Color color = this.world.getColor((int)((double)this.x + MathAccel.cos(this.angle - 45) * (double)VIEW_RANGE), (int)((double)this.y + MathAccel.sin(this.angle - 45) * (double)VIEW_RANGE), this);
        Color color2 = this.world.getColor((int)((double)this.x + MathAccel.cos(this.angle + 45) * (double)VIEW_RANGE), (int)((double)this.y + MathAccel.sin(this.angle + 45) * (double)VIEW_RANGE), this);
        this.brain.push(0, color.getRed());
        this.brain.push(1, color.getGreen());
        this.brain.push(2, color.getBlue());
        this.brain.push(3, color2.getRed());
        this.brain.push(4, color2.getGreen());
        this.brain.push(5, color2.getBlue());
        this.brain.push(6, this.health);
        this.brain.push(7, this.brain.pop(1));
        this.brain.push(8, this.brain.pop(0));
    }

    private void processOutputs() {
        int n = this.brain.pop(0);
        int n2 = n > 0 ? n : n * -1;
        this.health -= n2 / 80;
        this.xLevel = (int)((double)this.xLevel + (double)n * MathAccel.cos(this.angle));
        while (this.xLevel > STEP_LEVEL) {
            this.xLevel -= STEP_LEVEL;
            ++this.x;
        }
        while (this.xLevel < -STEP_LEVEL) {
            this.xLevel += STEP_LEVEL;
            --this.x;
        }
        this.yLevel = (int)((double)this.yLevel + (double)n * MathAccel.sin(this.angle));
        while (this.yLevel > STEP_LEVEL) {
            this.yLevel -= STEP_LEVEL;
            ++this.y;
        }
        while (this.yLevel < -STEP_LEVEL) {
            this.yLevel += STEP_LEVEL;
            --this.y;
        }
        n = this.brain.pop(1);
        this.angleLevel += n;
        while (this.angleLevel > STEP_LEVEL) {
            this.angleLevel -= STEP_LEVEL;
            ++this.angle;
        }
        while (this.angleLevel < -STEP_LEVEL) {
            this.angleLevel += STEP_LEVEL;
            --this.angle;
        }
        this.x = this.world.wrapX(this.x);
        this.y = this.world.wrapY(this.y);
        if (this.angle > 360) {
            this.angle -= 360;
        } else if (this.angle < 0) {
            this.angle += 360;
        }
    }

    public int getFoodChainLevel() {
        return this.foodChainLevel;
    }

    public void kill() {
        this.health = 0;
        this.die();
    }

    private void processOther() {
        StrangeCreature strangeCreature = this.world.checkContact(this.x, this.y, this, CREATURE_WIDTH);
        if (strangeCreature != null && this.isEdible(strangeCreature) && strangeCreature.getHealth() > 0) {
            strangeCreature.kill();
            this.health += 150;
            this.reproduce();
        }
    }

    public int getAge() {
        return this.age;
    }

    public abstract void reproduce();

    public abstract void die();

    public abstract boolean isEdible(StrangeCreature var1);
}

