/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;

public class StrangeController
implements Observer,
MouseListener,
KeyListener {
    private StrangeWorld world;
    private StrangeView view;
    private Color bgCol;
    public boolean doRendering = true;
    public boolean renderHigh = false;
    public boolean isPaused = false;

    public StrangeController(StrangeWorld strangeWorld, StrangeView strangeView) {
        this.world = strangeWorld;
        this.view = strangeView;
        this.doRendering = false;
        strangeView.addMouseListener(this);
        strangeView.addKeyListener(this);
        strangeWorld.addObserver(this);
        this.bgCol = new Color(0, 0, 0);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == 'h') {
            this.renderHigh = !this.renderHigh;
            Graphics2D graphics2D = (Graphics2D)this.view.getBufferGraphics();
            if (this.renderHigh) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            this.update(null, null);
        } else if (keyEvent.getKeyChar() == 'r') {
            this.doRendering = !this.doRendering;
        } else if (keyEvent.getKeyChar() == 'b') {
            this.bgCol = this.bgCol.getRed() > 0 ? new Color(0, 0, 0) : new Color(255, 255, 255);
            this.update(null, null);
        } else if (keyEvent.getKeyChar() == 'g') {
            StrangeCreature.healthView = !StrangeCreature.healthView;
            this.update(null, null);
        } else if (keyEvent.getKeyChar() == 'l') {
            StrangeCreature.vectorDraw = !StrangeCreature.vectorDraw;
            this.update(null, null);
        } else if (keyEvent.getKeyChar() == 'p') {
            this.isPaused = !this.isPaused;
        } else if (keyEvent.getKeyChar() == 'v') {
            StrangeCreature.renderView = !StrangeCreature.renderView;
            this.update(null, null);
        } else if (keyEvent.getKeyChar() == 'k') {
            if (StrangeCreature.selectedOne != null) {
                StrangeCreature.selectedOne.health = 0;
            }
        } else if (keyEvent.getKeyChar() == 'w') {
            StrangeCreature.wireframe = !StrangeCreature.wireframe;
            this.update(null, null);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        StrangeCreature strangeCreature = this.world.checkContact(mouseEvent.getX(), mouseEvent.getY(), null, StrangeCreature.CREATURE_WIDTH);
        if ((n & 0x10) > 0) {
            StrangeCreature.selectedOne = strangeCreature;
            this.update(null, null);
        } else if ((n & 8) > 0) {
            this.bgCol = this.bgCol.getRed() > 0 ? new Color(0, 0, 0) : new Color(255, 255, 255);
        } else if ((n & 4) > 0) {
            StrangeGeneCollection strangeGeneCollection = new StrangeGeneCollection(StrangePredator.eliteGene);
            strangeGeneCollection.mutate();
            StrangePredator strangePredator = new StrangePredator(strangeGeneCollection);
            strangePredator.move(mouseEvent.getX(), mouseEvent.getY());
            this.world.newCreature = strangePredator;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void update(Observable observable, Object object) {
        if (!this.view.isValidImage()) {
            this.view.createBufferImage();
        }
        if (this.doRendering && this.view.isValidImage()) {
            Graphics2D graphics2D = (Graphics2D)this.view.getBufferGraphics();
            graphics2D.setColor(this.bgCol);
            graphics2D.fillRect(0, 0, this.view.getWidth(), this.view.getHeight());
            ListIterator listIterator = (ListIterator)this.world.getCreatureIterator();
            while (listIterator.hasNext()) {
                ((StrangeCreature)listIterator.next()).draw(graphics2D);
            }
            this.view.repaint();
        }
    }
}

