/**************************************************************************
 *                                                                        *
 *  File:        hb8000.cpp                                               *
 *  Copyright:   (C) 2000, Florin Leon                                    *
 *  E-mail:      florinleon@yahoo.com                                     *
 *  Website:     http://www.angelfire.com/home/florinleon                 *
 *  Description: The program transforms .hex files into .bin files, with  *
 *               an option for loading starting at variable addresses,    *
 *               e.g., hb8000 assumes that 8000H bytes of ROM exist,      *
 *               which can't be written. Usual HexToBin applications      *
 *               generate 8000H zero bytes, and then the useful code.     *
 *               This program generates code starting at 8000H address,   *
 *               so it may be loaded more quickly into SBC.               *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 1, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program; if not, write to the Free Software           *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                        *
 **************************************************************************/


#include <stdio.h>
#include <string.h>
#include <ctype.h>

FILE *hex,*bin;
char numh[13],numb[13];
char buf[10000];
unsigned int min=-1,dim=0,max=0;


int verifnume()
{
    int p=0,k=0;

    numh[12]='\0';
    for (int i=0; numh[i]!='\0'; i++)
        numh[i]=tolower(numh[i]);

    for (i=0; numh[i]!='\0'; i++)
    {
        if (numh[i]=='.') p=1;
    }
    if (!p)
    {
        for (i=0; numh[i]!='\0'; i++);
        if (i>8) i=8;
        numh[i]='.'; 
        numh[i+1]='h';
        numh[i+2]='e'; 
        numh[i+3]='x';
    }
    else
    {
        for (i=0; numh[i]!='.'; i++);
        i++;
        if (numh[i]!='h' || numh[i+1]!='e' || numh[i+2]!='x') k=1;
    }

    printf("Sursa: %s\n",numh);

    for (i=0; numh[i]!='.'; i++)
        numb[i]=numh[i];
    strcat(numb,".bin");

    return k;
}


int tr(char c)
{
    int k;

    if (c<='9') k=c-'0';
    else k=c-'A'+10;
    return k;
}




void main(int argc, char* argv[])
{
    char lin[50];
    unsigned int adr;
    char octet,nroct;
    unsigned int i;


    if (argc!=2)
    {
        printf("Sintaxa: hb8000 fisier.hex\n");
        return;
    }

    strcpy(numh,argv[1]);

    if (verifnume())
    {
        printf("Fisierul sursa nu este de tip hex.\n");
        return;
    }

    if ((hex = fopen(numh,"rt")) == NULL)
    {
        fprintf(stderr, "Nu pot deschide fisierul sursa.\n");
        return;
    }

    printf("Destinatia: %s\n",numb);
    if ((bin = fopen(numb,"wb")) == NULL)
    {
        fprintf(stderr, "Nu pot deschide fisierul destinatie.\n");
        return;
    }




    while (!feof(hex))
    {
        lin[0]=' ';
        fgets(lin,50,hex);
        if (lin[0]!=':') break;

        nroct=(tr(lin[1]))*16+tr(lin[2]);
        if (nroct!=0)
        {
            adr=tr(lin[3])*4096+tr(lin[4])*256+tr(lin[5])*16+tr(lin[6]);
            if (adr>=0x8000)
            {
                if (adr<min) min=adr;
                if (adr+nroct>max) max=adr+nroct;
                dim+=nroct;
            }
        }
    }

    printf("Adresa minima: %Xh\n",min);
    fseek(hex,0,0);
    dim=max-min;
    for (i=0; i<dim; i++)
        buf[i]=0;

    while (!feof(hex))
    {
        lin[0]=' ';
        fgets(lin,50,hex);
        if (lin[0]!=':') break;

        nroct=(tr(lin[1]))*16+tr(lin[2]);
        adr=tr(lin[3])*4096+tr(lin[4])*256+tr(lin[5])*16+tr(lin[6]);

        if (adr>=0x8000)
        {
            for (i=0; i<nroct; i++)
            {
                octet=tr(lin[9+i*2])*16+tr(lin[10+i*2]);
                buf[i+adr-min]=octet;
            }
        }
    }

    for (i=0; i<dim; i++)
        fputc(buf[i],bin);

    fclose(hex);
    fclose(bin);
    delete buf;
}
