$MOD51		; ENABLE predefined 8051 registers

NAME	RUTINE_ARTIMETICE

Arit_Data	SEGMENT DATA
Arit_Code	SEGMENT CODE	


RSEG	Arit_Data

x:	DS 3
y:	DS 3
z:	DS 6
temp:	DS 6
op1:	DS 4
op2:	DS 4
sgn1:	DS 1
exp1:	DS 1
sgn2:	DS 1
exp2:	DS 1
rez:	DS 4
sgnrez:	DS 1
exprez:	DS 1


RSEG	Arit_Code

	ORG 8000h
	LJMP TEST


;------------------------------------------------------------------------------
;Rutine comune

Addit:
				;in x,y => out x,carry
	clr	c
	mov	a,x+2
	addc	a,y+2 
	mov	x+2,a
	mov	a,x+1
	addc	a,y+1
	mov	x+1,a
	mov	a,x
	addc	a,y
	mov	x,a
	jnc	Add1
	setb	c
Add1:
	ret


;------------------------------------------------------------------------------


Complem2:
				;in x => out x = C2(x)
	mov	a,x
	cpl	a	;not?
	mov	x,a
	mov	a,x+1
	cpl	a
	mov	x+1,a
	mov	a,x+2
	cpl	a
	mov	x+2,a

	mov	y+2,#1
	mov	y+1,#0
	mov	y,#0
	call	Addit
	ret


;------------------------------------------------------------------------------


ShiftL:
				;in-out temp[0-2 - 3 LSB]
	clr	c
	mov	a,temp+5
	rlc	a
	mov	temp+5,a
	mov	a,temp+4
	rlc	a
	mov	temp+4,a
	mov	a,temp+3
	rlc	a
	mov	temp+3,a
	ret    


;------------------------------------------------------------------------------


ShiftR:
				;in-out temp[0-2 - 3 LSB]
	clr	c
	mov	a,temp+3
	rrc	a
	mov	temp+3,a
	mov	a,temp+4
	rrc	a
	mov	temp+4,a
	mov	a,temp+5
	rrc	a
	mov	temp+5,a
	ret    


;------------------------------------------------------------------------------


ConvertIn:
				;in op1,op2[0-3] => out op1,op2[0-2],exp1,exp2,sgn1,sgn2
	clr	c
	mov	a,op1
	rlc	a
	mov	op1,a
	jc	CvIn1		;if (op1>=128) sgn1=1; else sgn1=0;
	mov	sgn1,#0
	jmp	CvIn2
CvIn1:	mov	sgn1,#1

CvIn2:	clr	c
	mov	a,op2
	rlc	a
	mov	op2,a
	jc	CvIn3		;if (op2>=128) sgn2=1; else sgn2=0;
	mov	sgn2,#0
	jmp	CvIn4
CvIn3:	mov	sgn2,#1

CvIn4:	mov	a,op1+1		;if (op1+1>=128) op1++; exp1=op1;
	rlc	a
	jnc	CvIn5
	inc	op1
CvIn5:	mov	exp1,op1
	
	mov	a,op2+1		;if (op2+1>=128) op2++; exp2=op2;
	rlc	a
	jnc	CvIn6
	inc	op2
CvIn6:	mov	exp2,op2

	mov	a,#0
	mov	rez,a
	mov	rez+1,a
	mov	rez+2,a
	mov	rez+3,a
	mov	exprez,a
	mov	sgnrez,a
	ret


;------------------------------------------------------------------------------


ConvertOut:
				;in rez[0-2],exprez,sgnrez => out rez[0-3]
	clr	c
	mov	a,exprez
	rrc	a
	mov	rez,a
	jnc	CvOut1
	orl	rez+1,#128
	jmp	CvOut2
CvOut1:	anl	rez+1,#127
CvOut2:	mov	a,sgnrez
	mov	r0,#7 
CvOut3:	rr a
	djnz	r0,CvOut3
	mov	b,rez
	add	a,b
	mov	rez,a
	ret


;------------------------------------------------------------------------------
;Adunare

FP_Add:
				;in op1,op2[0-2],exp1,exp2,sgn1,sgn2 => out rez[0-2],exprez,sgnrez
	mov	a,exp1
	mov	b,exp2
	clr	c
	subb	a,b
	jz	Etic1
	anl	a,#127
	jz	Cont
	jmp	sch

Etic1:					;exp1=exp2
	mov	a,op1+1
	mov	b,op2+1
	clr	c
	subb	a,b
	jz	Et2
	anl	a,#127
	jz	Cont
	jmp	sch

Et2:					;op2+1=op1+1
	mov	a,op1+2
	mov	b,op2+2
	clr	c
	subb	a,b
	jz	Et3
	anl	a,#127
	jz	Cont
	jmp	sch

Et3:					;op2+2=op1+2
	mov	a,op1+3	
	mov	b,op2+3
	clr	c
	subb	a,b
	jz	Et4
	anl	a,#127
	jz	Cont
	jmp	sch

Et4:					;op2+3=op1+3
	mov	a,sgn1
	cjne	a,sgn2,GoEnd		;op1=op2 si sgn1!=sgn2 => rez=rez+1=rez+2=rez+3=exp1=0;
	jmp	Cont

GoEnd:	jmp	FPA_End

Sch:
	mov	temp+3,op1+1
	mov	temp+4,op1+2
	mov	temp+5,op1+3
	mov	temp+2,exp1
	mov	temp+1,sgn1

	mov	op1+1,op2+1
	mov	op1+2,op2+2
	mov	op1+3,op2+3
	mov	exp1,exp2
	mov	sgn1,sgn2

	mov	op2+1,temp+3
	mov	op2+2,temp+4
	mov	op2+3,temp+5
	mov	exp2,temp+2
	mov	sgn2,temp+1

Cont:
	mov	exprez,exp1
	mov	sgnrez,sgn1

	mov	a,#0
	orl	a,op1+3
	orl	a,op1+2
	orl	a,op1+1
	orl	a,op1
	jz	Cont2
	orl	op1+1,#128			;if (op1 || op1+1 || op1+2 || op1+3) op1+1|=0x80; - mantisa cu 1 in Msgn2

Cont2:	mov	a,#0
	orl	a,op2+3
	orl	a,op2+2
	orl	a,op2+1
	orl	a,op2
	jz	Cont3
	orl	op2+1,#128			;analog pentru op2

Cont3:	mov	a,exp1
	mov	b,exp2
	clr	c
	subb	a,b
	jz	FPA_2
	mov	r0,a
	
FPA_1:	mov	temp+3,op2+1
	mov	temp+4,op2+2
	mov	temp+5,op2+3
	call	ShiftR
	mov	op2+1,temp+3
	mov	op2+2,temp+4
	mov	op2+3,temp+5
	inc	exp2
	djnz	r0,FPA_1

FPA_2:	mov	a,sgn1
	jz	FPA_3
	mov	x,op1+1
	mov	x+1,op1+2
	mov	x+2,op1+3
	call	Complem2
	mov	op1+1,x
	mov	op1+2,x+1
	mov	op1+3,x+2

FPA_3:	mov	a,sgn2
	jz	FPA_4
	mov	x,op2+1
	mov	x+1,op2+2
	mov	x+2,op2+3
	call	Complem2
	mov	op2+1,x
	mov	op2+2,x+1
	mov	op2+3,x+2

FPA_4:	mov	x,op1+1
	mov	x+1,op1+2
	mov	x+2,op1+3
	mov	y,op2+1
	mov	y+1,op2+2
	mov	y+2,op2+3
	call	Addit
	mov	rez+1,x
	mov	rez+2,x+1
	mov	rez+3,x+2
	jnc	NotC2
	mov	r1,#1
	jmp	Acont1
NotC2:	mov	r1,#0

Acont1:	mov	a,sgnrez
	jz	FPA_6
	mov	x,rez+1
	mov	x+1,rez+2
	mov	x+2,rez+3
	call	Complem2
	mov	rez+1,x
	mov	rez+2,x+1
	mov	rez+3,x+2
	mov	a,r1
	jz	FPA_5
	mov	r1,#0
	jmp	FPA_6
FPA_5:	mov	r1,#1

FPA_6:	mov	a,sgn1
	cjne	a,sgn2,FPA_7
	jmp	FPA_8
FPA_7:	mov	r1,#0

FPA_8:	mov	a,r1
	jz	FPA_9
	mov	temp+3,rez+1
	mov	temp+4,rez+2
	mov	temp+5,rez+3
	call	ShiftR
	mov	rez+1,temp+3
	mov	rez+2,temp+4
	mov	rez+3,temp+5
	inc	exprez
	orl	rez+1,#128

FPA_9:	mov	a,#0
	orl	a,rez+1
	orl	a,rez+2
	orl	a,rez+3
	jz	FPA_End

FPA_10:	mov	a,rez+1
	anl	a,#128
	jnz	FPA_End
	mov	temp+3,rez+1
	mov	temp+4,rez+2
	mov	temp+5,rez+3
	call	ShiftL
	mov	rez+1,temp+3
	mov	rez+2,temp+4
	mov	rez+3,temp+5
	dec	exprez

FPA_End:
	ret



;------------------------------------------------------------------------------
;scadere


FP_Sub:
				;in a,b[0-2],exp1,exp2,sgn1,sgn2 => out c[0-2],exprez,sgnrez
	mov	a,sgn2
	jz	FPS_1
	mov	sgn2,#0
	jmp	FPS_2
FPS_1:	mov	sgn2,#1
FPS_2:	call	FP_Add
	ret

;------------------------------------------------------------------------------
;Inmultire

Multip:
				;in x,y[0-2] => out z[0-5]
	mov	a,#0
	mov	z,a
	mov	z+1,a
	mov	z+2,a
	mov	z+3,a
	mov	z+4,a
	mov	z+5,a

	mov	b,x+2
	mov	a,y+2
	mul	ab
	mov	z+5,a
	mov	z+4,b

	mov	b,x+2
	mov	a,y+1
	mul	ab
	add	a,z+4
	mov	z+4,a
	mov	a,b
	addc	a,z+3
	mov	z+3,a
	jnc	Mul1
	inc	z+2

Mul1:	mov	b,x+1
	mov	a,y+2
	mul	ab
	add	a,z+4
	mov	z+4,a
	mov	a,b
	addc	a,z+3
	mov	z+3,a
	jnc	Mul2
	inc	z+2

Mul2:	mov	b,x+2
	mov	a,y
	mul	ab
	add	a,z+3
	mov	z+3,a
	mov	a,b
	addc	a,z+2
	mov	z+2,a
	jnc	Mul3
	inc	z+1
 
Mul3:	mov	b,x+1
	mov	a,y+1
	mul	ab
	add	a,z+3
	mov	z+3,a
	mov	a,b
	addc	a,z+2
	mov	z+2,a
	jnc	Mul4
	inc	z+1

Mul4:	mov	b,x
	mov	a,y+2
	mul	ab
	add	a,z+3
	mov	z+3,a
	mov	a,b
	addc	a,z+2
	mov	z+2,a
	jnc	Mul5
	inc	z+1
 
Mul5:	mov	b,x+1
	mov	a,y
	mul	ab
	add	a,z+2
	mov	z+2,a
	mov	a,b
	addc	a,z+1
	mov	z+1,a
	jnc	Mul6
	inc	z
    
Mul6:	mov	b,x
	mov	a,y+1
	mul	ab
	add	a,z+2
	mov	z+2,a
	mov	a,b
	addc	a,z+1
	mov	z+1,a
	jnc	Mul7
	inc	z
    
Mul7:	mov	b,x
	mov	a,y
	mul	ab
	add	a,z+1
	mov	z+1,a
	mov	a,b
	addc	a,z
	mov	z,a
	ret    


;------------------------------------------------------------------------------


FP_Mul:
				;in op1,op2[0-2],exp1,exp2,sgn1,sgn2 => out rez[0-2],exprez,sgnrez
	mov	a,sgn1
	xrl	a,sgn2
	mov	sgnrez,a

	mov	a,exp1
	clr	c
	rrc	a
	mov	r0,a
	mov	a,exp2
	clr	c
	rrc	a
	mov	r1,a
	
	mov	a,r0
	add	a,r1
	mov	r0,a

	mov	a,#190
	clr	c
	subb	a,r0
	anl	a,#127
	jz	FPM_1
	mov	exprez,#0FFh		;depasire plus (suma exponentilor > 127)
	jmp	FPM_End

FPM_1:	mov	a,#64
	clr	c
	subb	a,r0
	anl	a,#127
	jz	FPM_End			;depasire minus (suma exponentilor < -127)

	mov	a,#0
	orl	a,op1+3
	orl	a,op1+2
	orl	a,op1+1
	orl	a,op1
	jz	FPM_End
	orl	op1+1,#128			;if (op1 || op1+1 || op1+2 || op1+3) op1+1|=0x80; - mantisa cu 1 in Msgn2

	mov	a,#0
	orl	a,op2+3
	orl	a,op2+2
	orl	a,op2+1
	orl	a,op2
	jz	FPM_End
	orl	op2+1,#128			;analog pentru op2

	mov	x,op1+1 
	mov	x+1,op1+2
	mov	x+2,op1+3
	mov	y,op2+1
	mov	y+1,op2+2
	mov	y+2,op2+3
	call	Multip
	mov	rez+1,z
	mov	rez+2,z+1
	mov	rez+3,z+2

	mov	x,#0
	mov	x+1,#0
	mov	x+2,exp1
	mov	y,#0
	mov	y+1,#0
	mov	y+2,exp2
	call	Addit
	mov	y,#0
	mov	y+1,#0
	mov	y+2,#81h			;-127
	call	Addit
	inc	x+2
	mov	exprez,x+2

	clr	c
	mov	a,rez+1
	rlc	a
	jc	FPM_End			;rez+1>=128
	mov	temp+3,rez+1
	mov	temp+4,rez+2
	mov	temp+5,rez+3
	call	ShiftL
	mov	rez+1,temp+3
	mov	rez+2,temp+4
	mov	rez+3,temp+5
	dec	exprez
 
FPM_End:	
	ret



;------------------------------------------------------------------------------
;Impartire

Divis:
				;in z[0-5],y[0-2] => out x[0-2],carry
	mov	a,#0
	mov	r7,a
	mov	r6,a
	mov	r5,a
	mov	temp+5,a
	mov	temp+4,a
	mov	temp+3,a
	mov	temp+2,a
	mov	temp+1,a
	mov	temp,a
	clr	c

	mov	r2,y
	mov	r1,y+1
	mov	r0,y+2
	mov	r4,#48

Div_loop:
	call	Shift_D
	mov	a,r5
	rlc	a
	mov	r5,a
	mov	a,r6
	rlc	a
	mov	r6,a
	mov	a,r7
	rlc	a
	mov	r7,a

	jc	Can_sub
	clr	c
	mov	a,r7
	subb	a,r2
	jc	Cant_sub

	jnz	Can_sub

	clr	c
	mov	a,r6
	subb	a,r1
	jc	Cant_sub

	jnz	Can_sub
	clr	c
	mov	a,r5
	subb	a,r0
	jc	Cant_sub
    
Can_sub:
	clr	c
	mov	a,r5
	subb	a,r0
	mov	r5,a
	mov	a,r6
	subb	a,r1
	mov	r6,a
	mov	a,r7
	subb	a,r2
	mov	r7,a
	setb	c
	jmp	Quot
    

Cant_sub:
	clr	c

Quot:
	call	Shift_Q
	djnz	r4,Div_loop
	
	mov	a,temp+2
	jz	Div1
	setb	c
Div1:	mov	x,temp+3
	mov	x+1,temp+4
	mov	x+2,temp+5
	ret
	
    
Shift_D:
	clr	c
	mov	a,z+5
	rlc	a
	mov	z+5,a
	mov	a,z+4
	rlc	a
	mov	z+4,a
	mov	a,z+3
	rlc	a
	mov	z+3,a
	mov	a,z+2
	rlc	a
	mov	z+2,a
	mov	a,z+1
	rlc	a
	mov	z+1,a
	mov	a,z
	rlc	a
	mov	z,a
	ret

Shift_Q:
	mov	a,temp+5
	rlc	a
	mov	temp+5,a
	mov	a,temp+4
	rlc	a
	mov	temp+4,a
	mov	a,temp+3
	rlc	a
	mov	temp+3,a
	mov	a,temp+2
	rlc	a
	mov	temp+2,a
	mov	a,temp+1
	rlc	a
	mov	temp+1,a
	mov	a,temp
	rlc	a
	mov	temp,a
	ret
    


;------------------------------------------------------------------------------



FP_Div:
				;in op1,op2[0-2],exp1,exp2,sgn1,sgn2 => out rez[0-2],exprez,sgnrez
	mov	a,sgn1
	xrl	a,sgn2
	mov	sgnrez,a

	mov	a,#0
	orl	a,op2
	orl	a,op2+1
	orl	a,op2+2
	orl	a,op2+3
	jnz	FPD_2		;salt daca op2!=0

	mov	a,#0
	orl	a,op1
	orl	a,op1+1
	orl	a,op1+2
	orl	a,op1+3
	jnz	FPD_1		;salt daca op1!=0
	mov	exprez,#0FFh
	mov	rez+2,#0
	mov	rez+3,#0
	mov	rez+1,#1		;forma fara sens 0/0
	jmp	FPD_End
	
FPD_1:	mov	exprez,#0FFh
	mov	rez+2,#0
	mov	rez+3,#0
	mov	rez+1,#0		;impartire la 0
	jmp	FPD_End

FPD_2:	mov	a,exp2
	mov	b,exp1
	clr	c
	subb	a,b
	clr	c
	subb	a,#127
	anl	a,#127
	jnz	Dcont0			;depasire minus (exp op2 - exp op1 > 127)
	jmp	FPD_End	

DCont0:	mov	a,exp1
	mov	b,exp2
	clr	c
	subb	a,b
	clr	c
	subb	a,#127
	anl	a,#127
	jnz	FPD_3
	mov	exprez,#0FFh		
	jmp	FPD_End			;depasire plus (exp op1 - exp op2 > 127)

FPD_3:	mov	a,#0
	orl	a,op1+3
	orl	a,op1+2
	orl	a,op1+1
	orl	a,op1
	jz	FPD_4
	orl	op1+1,#128			;if (op1 || op1+1 || op1+2 || op1+3) op1+1|=0x80; - mantisa cu 1 in Msgn2

FPD_4:	mov	a,#0
	orl	a,op2+3
	orl	a,op2+2
	orl	a,op2+1
	orl	a,op2
	jz	FPD_5
	orl	op2+1,#128			;analog pentru op2

FPD_5:	mov	z,op1+1
	mov	z+1,op1+2
	mov	z+2,op1+3
	mov	z+3,#0
	mov	z+4,#0
	mov	z+5,#0
	mov	y,op2+1
	mov	y+1,op2+2
	mov	y+2,op2+3
	call	Divis
	jnc	NotC1
	mov	r1,#1
	jmp	Dcont1
NotC1:	mov	r1,#0

Dcont1:	mov	rez+1,x
	mov	rez+2,x+1
	mov	rez+3,x+2

	mov	x,#0
	mov	x+1,#0
	mov	x+2,exp1
	mov	a,exp2
	cpl	a	;not?
	inc	a
	mov	exp2,a
	mov	y,#0
	mov	y+1,#0
	mov	y+2,exp2
	call	Addit
	mov	y,#0
	mov	y+1,#0
	mov	y+2,#127		;+127
	call	Addit

	dec	x+2
	mov	exprez,x+2

	mov	a,r1		
	jnz	Dcont2		;salt daca r1=0
	jmp	FPD_End

Dcont2:	mov	temp+3,rez+1
	mov	temp+4,rez+2
	mov	temp+5,rez+3
	call	ShiftR
	mov	rez+1,temp+3
	mov	rez+2,temp+4
	mov	rez+3,temp+5
	inc	exprez

FPD_End:	
	ret



;------------------------------------------------------------------------------


Afisare:
	mov	a,rez
	lcall	1bf8h
	lcall	1c0dh
	mov	a,rez+1
	lcall	1bf8h
	lcall	1c0dh
	mov	a,rez+2
	lcall	1bf8h
	lcall	1c0dh
	mov	a,rez+3
	lcall	1bf8h
	lcall	1c0dh
	ret


TEST:	
	mov	op1,#0c0h
	mov	op1+1,#43h
	mov	op1+2,#22h
	mov	op1+3,#0c8h

	mov	op2,#0c0h
	mov	op2+1,#0feh
	mov	op2+2,#4h
	mov	op2+3,#0f4h

	call	ConvertIn
	call	FP_Add
	call	ConvertOut
	call	Afisare

	ret


END
