/**************************************************************************
 *                                                                        *
 *  File:        Unit1.cpp                                                *
 *  Copyright:   (C) 2002, Florin Leon                                    *
 *  E-mail:      florinleon@yahoo.com                                     *
 *  Website:     http://www.angelfire.com/home/florinleon                 *
 *  Description: It generates passwords of any length, composed of a      *
 *               custom number of uppercase letters, lowercase letters,   *
 *               digits and special characters.                           *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 1, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program; if not, write to the Free Software           *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                        *
 **************************************************************************/

#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
#include "stdlib.h"
#include "time.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

char mici[100];
char mari[100];
char cifre[100];
char speciale[100];

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
int TForm1::CalcTotal()
{
    int val, tot=0;
    val = Edit1->Text.ToIntDef(-1);
    if (val<0) { Edit5->Text = "eroare"; return -1; }
    tot += val;

    val = Edit2->Text.ToIntDef(-1);
    if (val<0) { Edit5->Text = "eroare"; return -1; }
    tot += val;

    val = Edit3->Text.ToIntDef(-1);
    if (val<0) { Edit5->Text = "eroare"; return -1; }
    tot += val;

    val = Edit4->Text.ToIntDef(-1);
    if (val<0) { Edit5->Text = "eroare"; return -1; }
    tot += val;

    Edit5->Text = tot;
    return tot;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Edit1Change(TObject *Sender)
{
    CalcTotal();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
    randomize();
    Edit1->Text = random(5);
    Edit2->Text = random(5);
    Edit3->Text = random(5);
    Edit4->Text = random(5);
    Edit5->Text = random(5);
    CalcTotal();

    strcpy(mici, Edit7->Text.c_str());
    strcpy(mari, Edit8->Text.c_str());
    strcpy(cifre, Edit9->Text.c_str());
    strcpy(speciale, Edit10->Text.c_str());
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Edit2Change(TObject *Sender)
{
    CalcTotal();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Edit3Change(TObject *Sender)
{
    CalcTotal();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Edit4Change(TObject *Sender)
{
    CalcTotal();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    Edit6->Text="";
    int tot = Edit5->Text.ToIntDef(-1);
    if (tot==-1) return;

    AnsiString pass="";

    for (int i=0; i<Edit1->Text.ToIntDef(0); i++) {
        int t = random(Edit7->Text.Length());
        pass += mici[t];
    }

    for (int i=0; i<Edit2->Text.ToIntDef(0); i++) {
        int t = random(Edit8->Text.Length());
        pass += mari[t];
    }

    for (int i=0; i<Edit3->Text.ToIntDef(0); i++) {
        int t = random(Edit9->Text.Length());
        pass += cifre[t];
    }

    for (int i=0; i<Edit4->Text.ToIntDef(0); i++) {
        int t = random(Edit10->Text.Length());
        pass += speciale[t];
    }

    int *v = new int[tot];
    for (int i=0; i<tot; i++)
        v[i] = random(10000);

    int dist, i, j, aux;
    int len=tot;

    for (dist=len/2; dist>0; dist/=2)
        for (i=dist; i<len; i++)
            for (j=i-dist; j>=0 && v[j]>v[j+dist]; j-=dist)
            {
                aux=v[j]; v[j]=v[j+1]; v[j+1]=aux;
                char c = pass.c_str()[j];
                pass.c_str()[j]= pass.c_str()[j+1];
                pass.c_str()[j+1]=c;
            }

    delete []v;

    Edit6->Text = pass;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
    Edit1->Text = random(15);
    Edit2->Text = random(15);
    Edit3->Text = random(15);
    Edit4->Text = random(15);
    Edit5->Text = random(15);
    CalcTotal();
    Button1Click(this);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit7Change(TObject *Sender)
{
    strcpy(mici, Edit7->Text.c_str());
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit8Change(TObject *Sender)
{
    strcpy(mari, Edit8->Text.c_str());
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit9Change(TObject *Sender)
{
    strcpy(cifre, Edit9->Text.c_str());
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit10Change(TObject *Sender)
{
    strcpy(speciale, Edit10->Text.c_str());
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
    Edit7->Text = "abcdefghijklmnopqrstuvwxyz";
    Edit8->Text = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    Edit9->Text = "0123456789";
    Edit10->Text = "~!@#$%^&*_";
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Button4Click(TObject *Sender)
{
    AnsiString as = "Copyright 2002, Florin Leon\n";
    as += "\nhttp://www.angelfire.com/home/florinleon\n";
    as += "http://fleon.de.vu";
    ShowMessage(as);
}
//---------------------------------------------------------------------------

