#ifndef __SYMTABC
#define __SYMTABC


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "yytab.h"
#include "symtab.h"

/* SIZE is the size of the hash table */
#define SIZE 211

/* SHIFT is the power of two used as multiplier
   in hash function  */
#define SHIFT 4

//---------------------------------------------------------------------------

int temp_h=0, i_h=0;

/* the hash function */
int hash ( char * key )
{
temp_h = 0;
i_h = 0;

while (key[i_h] != '\0')
      {
      temp_h = ((temp_h << SHIFT) + key[i_h]) % SIZE;
      ++i_h;
      }
return temp_h;
}

//---------------------------------------------------------------------------

/* the list of line numbers of the source
 * code in which a variable is referenced
 */
typedef struct LineListRec
        {
        int lineno;
        struct LineListRec * next;
        } * LineList;

/* The record in the bucket lists for
 * each variable, including name,
 * assigned memory location, and
 * the list of line numbers in which
 * it appears in the source code
 */
typedef struct BucketListRec
        {
        char * name;
        LineList lines;
        int type;
        int memloc ; /* memory location for variable */
        struct BucketListRec * next;
        } * BucketList;

/* the hash table */
static BucketList hashTable[SIZE];

//---------------------------------------------------------------------------

void clear_symtab()
{
for (int i=0; i<SIZE; i++)
    hashTable[i]=NULL;
}

//---------------------------------------------------------------------------

/* Procedure st_insert inserts line numbers and
 * memory locations into the symbol table
 * loc = memory location is inserted only the
 * first time, otherwise ignored
 */
int st_insert(char * name, int lineno, int loc, int tip)
{
int exists;

int h = hash(name);
BucketList l =  hashTable[h];

while ((l != NULL) && (strcmp(name,l->name) != 0))
      l = l->next;
if (l == NULL) /* variable not yet in table */
   {
   exists=0;
   l = (BucketList) malloc(sizeof(struct BucketListRec));
   l->name = name;
   l->lines = (LineList) malloc(sizeof(struct LineListRec));
   l->lines->lineno = lineno;
   l->memloc = loc;
   l->type = tip;
   l->lines->next = NULL;
   l->next = hashTable[h];
   hashTable[h] = l;
   }
else /* found in table, so just add line number */
   {
   exists=1;
   LineList t = l->lines;
   while (t->next != NULL) t = t->next;
   t->next = (LineList) malloc(sizeof(struct LineListRec));
   t->next->lineno = lineno;
   t->next->next = NULL;
   }
return exists;

} /* st_insert */

//---------------------------------------------------------------------------

/* Function st_lookup returns the memory
 * location of a variable or -1 if not found
 */
int st_lookup ( char * name, int &tip )
{
int h = hash(name);
BucketList l =  hashTable[h];
while ((l != NULL) && (strcmp(name,l->name) != 0))
      l = l->next;
if (l == NULL) return -1;
else
    {
    tip=l->type;
    return l->memloc;
    }
}

//---------------------------------------------------------------------------

/* Procedure printSymTab prints a formatted
 * listing of the symbol table contents
 * to the fout file
 */
void printSymTab(FILE * fout)
{ int i;
  fprintf(fout,"Variable Name  Type  Location  Line Numbers\n");
  fprintf(fout,"-------------  ----  --------  ------------\n");
  for (i=0;i<SIZE;++i)
  { if (hashTable[i] != NULL)
    { BucketList l = hashTable[i];
      while (l != NULL)
      { LineList t = l->lines;
        fprintf(fout,"%-14s ",l->name);
        if (l->type==INT_TYPE)
           fprintf(fout,"%-6s ","Int");
        else
            fprintf(fout,"%-6s ","Real");
        fprintf(fout,"%6d ",l->memloc);
        while (t != NULL)
        { fprintf(fout,"%4d ",t->lineno);
          t = t->next;
        }
        fprintf(fout,"\n");
        l = l->next;
      }
    }
  }
} /* printSymTab */


#endif

