#ifndef __PARSEC
#define __PARSEC

#include "globals.h"
#include "util.h"
#include "scan.h"
#include "parse.h"
#include "Unit3.h"

/* function prototypes for recursive calls */
static TreeNode * stmt_sequence(void);
static TreeNode * decl_sequence(void);
static TreeNode * statement(void);
static TreeNode * if_stmt(void);
static TreeNode * decl_stmt(void);
static TreeNode * while_stmt(void);
static TreeNode * for_stmt(void);
static TreeNode * assign_stmt(void);
static TreeNode * read_stmt(void);
static TreeNode * write_stmt(void);
static TreeNode * exp(void);
static TreeNode * simple_exp(void);
static TreeNode * term(void);
static TreeNode * powterm(void);
static TreeNode * factor(void);

static TokenType token; /* holds current token */
extern Lexem lex[25000];
extern int lexcnt;
int linenr;
extern int nrlexem;
extern TForm3 *Form3;
int isblock;


int gettoken()
{
strcpy(tokenString,lex[lexcnt].nume.c_str());
linenr=lex[lexcnt].linie;
return lex[lexcnt].cod;
}


int mylex()
{
lexcnt++;
if (lexcnt>nrlexem) return ERR;
while (lex[lexcnt].cod==WHITESPACE) lexcnt++;
strcpy(tokenString,lex[lexcnt].nume.c_str());
linenr=lex[lexcnt].linie;
return lex[lexcnt].cod;
}


static void match(TokenType expected)
{
if (token == expected) token = mylex();
else
    {
    AnsiString m="Unexpected token -> ";
    m+=tokenString;
    Form3->SyntaxError(m,linenr);
    }
}


static void matchSC()
{
if (token==SC) token = mylex();
else
   {
   AnsiString m="; expected";
   Form3->SyntaxError(m,linenr);
   }
}


TreeNode * stmt_sequence(void)
{
TreeNode * t = statement(); 
TreeNode * p = t; 

while ((token!=ENDB) && (token!=ENDP) && (token!=ELSE) && (lexcnt<nrlexem))
      {
      TreeNode * q;
      q = statement();
      if (q!=NULL)
         {
         if (t==NULL) t = p = q;
         else /* now p cannot be NULL either */
            {
            p->sibling = q;
            p = q;
            }
         }
      }

if (token==ENDB) match(ENDB);
return t;
}



TreeNode * statement(void)
{ TreeNode * t = NULL;

try{
  switch (token) {
    case IF : t = if_stmt(); break;
    case WHILE: t = while_stmt(); break;
    case FOR : t = for_stmt(); break;
    case ID : t = assign_stmt(); matchSC(); break;
    case READ : t = read_stmt(); matchSC(); break;
    case WRITE : t = write_stmt(); matchSC();break;
    case INTK :
    case REALK : t = decl_stmt(); matchSC(); break;
    default :
            AnsiString m="Unexpected token -> ";
            m+=tokenString;
            Form3->SyntaxError(m,linenr);
            token = mylex();
            break;
  } /* end case */
    }
  catch(...) { }
  return t;
}


TreeNode * if_stmt(void)
{
TreeNode * t = newStmtNode(IfK);
if (t!=NULL) t->attr.name = copyString(tokenString);
match(IF);
if (t!=NULL) t->child[0] = exp();

match(THEN);
if (token==STB) { match(STB); isblock=1; }
else isblock=0;
t->child[1] = newStmtNode(ThenK);
if (isblock) t->child[1]->child[0] = stmt_sequence();
else t->child[1]->child[0] = statement();

if (token==ELSE)
   {
   match(ELSE);
   if (token==STB) { match(STB); isblock=1; }
   else isblock=0;
   t->child[2] = newStmtNode(ElseK);
   if (isblock) t->child[2]->child[0] = stmt_sequence();
   else t->child[2]->child[0] = statement();
   }
return t;
}


static TreeNode * decl_stmt(void)
{
TreeNode * t = newStmtNode(DeclK);
int tip=token;

if (token==INTK) match(INTK);
else match(REALK);
if ((t!=NULL) && (token==ID))
   t->attr.name = copyString(tokenString);
TreeNode * p = newExpNode(IdK);
p->attr.name = copyString(tokenString);
p->type=(tip==INTK) ? INT_TYPE : REAL_TYPE;  
t->child[0]=p;
match(ID);

return t;
}



TreeNode * while_stmt(void)
{
TreeNode * t = newStmtNode(WhileK);
match(WHILE);
if (t!=NULL) t->child[0] = exp();
if (token==STB) { match(STB); isblock=1; }
else isblock=0;
t->child[1] = newStmtNode(DoK);
if (isblock) t->child[1]->child[0] = stmt_sequence();
else t->child[1]->child[0] = statement();
return t;
}



TreeNode * for_stmt(void)
{
TreeNode * t = newStmtNode(ForK);

match(FOR);
if (t!=NULL) t->child[0] = assign_stmt();

match(TO);
t->child[1] = newStmtNode(ToK);
t->child[1]->child[0] = exp();

match(STEP);
t->child[2] = newStmtNode(StepK);
t->child[2]->child[0] = exp();

if (token==STB) { match(STB); isblock=1; }
else isblock=0;
t->child[3] = newStmtNode(DoK);
if (isblock) t->child[3]->child[0] = stmt_sequence();
else t->child[3]->child[0] = statement();

return t;
}


TreeNode * assign_stmt(void)
{
TreeNode * t = newStmtNode(AssignK);
if ((t!=NULL) && (token==ID))
   t->attr.name = copyString(tokenString);
match(ID);
match(ASSIGN);
if (t!=NULL) t->child[0] = exp();

return t;
}


TreeNode * read_stmt(void)
{
TreeNode * t = newStmtNode(ReadK);
match(READ);
if ((t!=NULL) && (token==ID))
   t->attr.name = copyString(tokenString);
match(ID);
return t;
}


TreeNode * write_stmt(void)
{
TreeNode * t = newStmtNode(WriteK);
match(WRITE);
if (t!=NULL) t->child[0] = exp();
return t;
}


TreeNode * exp(void)
{
TreeNode * t = simple_exp();

if ((token==EQ) || (token==DIF) || (token==LT) || (token==GT))
   {
   TreeNode * p = newExpNode(TestK);
   if (p!=NULL)
      {
      p->child[0] = t;
      p->attr.op = token;
      t = p;
      }
   match(token);
   if (t!=NULL)
      t->child[1] = simple_exp();
   }
return t;
}


TreeNode * simple_exp(void)
{
if (token==SUB)
   {
   TreeNode * p = newExpNode(OpK);  
   if (p!=NULL)
      {
      p->attr.op = token;
      match(token);
      p->child[0] = term();
      }
   return p;
   }

TreeNode * t = term();

while ((token==ADD) || (token==SUB))
      {
      TreeNode * p = newExpNode(OpK);
      if (p!=NULL)
         {
         p->child[0] = t;
         p->attr.op = token;
         t = p;
         match(token);
         t->child[1] = term();
         }
      }
return t;
}


TreeNode * term(void)
{
TreeNode * t = powterm();
while ((token==MUL) || (token==DIV))
      {
      TreeNode * p = newExpNode(OpK); 
      if (p!=NULL) 
         {
         p->child[0] = t; 
         p->attr.op = token; 
         t = p; 
         match(token); 
         p->child[1] = powterm(); 
         }
      }
return t; 
}


TreeNode * powterm(void)
{
TreeNode * t = factor(); 
while (token==POW)
      {
      TreeNode * p = newExpNode(OpK); 
      if (p!=NULL) 
         {
         p->child[0] = t; 
         p->attr.op = token; 
         t = p; 
         match(token); 
         p->child[1] = factor(); 
         }
      }
return t; 
}


TreeNode * factor(void)
{
TreeNode * t = NULL; 
switch (token) 
       {
       case INT :
                 t = newExpNode(ConstK); 
                 if ((t!=NULL) && (token==INT))
                    {
                    t->attr.val = atoi(tokenString);
                    t->type = INT_TYPE;
                    }
                 match(INT);
                 break;
       case REAL :
                 t = newExpNode(ConstK);
                 if ((t!=NULL) && (token==REAL))
                    {
                    t->attr.val = atof(tokenString);
                    t->type = REAL_TYPE;
                    }
                 match(REAL);
                 break; 
       case ID :
                 t = newExpNode(IdK); 
                 if ((t!=NULL) && (token==ID))
                    t->attr.name = copyString(tokenString); 
                 match(ID); 
                 break; 
       case LPAR :
                 match(LPAR); 
                 t = exp(); 
                 match(RPAR); 
                 break; 
       default:
                 AnsiString m="Unexpected token -> "; 
                 m+=tokenString; 
                 Form3->SyntaxError(m,linenr);
                 
                 printToken(token,tokenString); 
                 token = mylex(); 
                 break; 
       }
return t; 
}

/****************************************/
/* the primary function of the parser   */
/****************************************/
/* Function parse returns the newly
* constructed syntax tree
*/
TreeNode * parse(void)
{
TreeNode * t; 
lexcnt=0; 
token = gettoken(); 
match(STP); 
t = stmt_sequence(); 
if (token!=ENDP)
   {
   AnsiString m="Code ends before file"; 
   Form3->SyntaxError(m,linenr);
   }
else match(ENDP); 
return t; 
}


#endif

