#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

/* Yacc/Bison generates internally its own values
 * for the tokens. Other files can access these values
 * by including the tab.h file generated using the
 * Yacc/Bison option -d ("generate header")
 *
 * The YYPARSER flag prevents inclusion of the tab.h
 * into the Yacc/Bison output itself
 */

#ifndef YYPARSER


/* ENDFILE is implicitly defined by Yacc/Bison,
 * and not included in the tab.h file
 */
#define ENDFILE 0

#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

/* MAXRESERVED = the number of reserved words */
#define MAXRESERVED 8

/* Yacc/Bison generates its own integer values
 * for tokens
 */
//typedef int TokenType;
#define TokenType int

//FILE* source; /* source code text file */
//FILE* listing; /* listing output text file */
//FILE* code; /* code text file for TM simulator */

int lineno; /* source line number for listing */

/**************************************************/
/***********   Syntax tree for parsing ************/
/**************************************************/

typedef enum {StmtK=1, ExpK} NodeKind;
typedef enum {IfK=100, ThenK, ElseK, WhileK, ForK, ToK, StepK,
              AssignK, ReadK, WriteK, DeclK, DoK} StmtKind;
typedef enum {OpK=120, TestK, ConstK, IdK} ExpKind;

/* ExpType is used for type checking */
typedef enum {Void=14, Integer, Real} ExpType;

#define MAXCHILDREN 5

typedef struct treeNode
   { struct treeNode * child[MAXCHILDREN];
     struct treeNode * sibling;
     int lineno;
     int nodekind;
     union { int stmt; int exp;} kind;
     union { TokenType op;
             float val;
             char * name; } attr;
     ExpType type; /* for type checking of exps */
   } TreeNode;


struct Lexem
       {
       int cod;
       AnsiString nume;
       int linie;
       };


/**************************************************/
/***********   Flags for tracing       ************/
/**************************************************/

/* EchoSource = TRUE causes the source program to
 * be echoed to the listing file with line numbers
 * during parsing
 */
int EchoSource;

/* TraceScan = TRUE causes token information to be
 * printed to the listing file as each token is
 * recognized by the scanner
 */
int TraceScan;

/* TraceParse = TRUE causes the syntax tree to be
 * printed to the listing file in linearized form
 * (using indents for children)
 */
int TraceParse;

/* TraceAnalyze = TRUE causes symbol table inserts
 * and lookups to be reported to the listing file
 */
int TraceAnalyze;

/* TraceCode = TRUE causes comments to be written
 * to the TM code file as code is generated
 */
int TraceCode;

/* Error = TRUE prevents further passes if an error occurs */
int Error; 
#endif

