//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
#include "Unit4.h"
#include "Unit5.h"
#include "Unit6.h"
#include "Unit7.h"
#include "globals.h"
#include "symtab.c"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm6 *Form6;

char memory[1000];
char numar[50];
AnsiString capt;
int ival_read; float fval_read; int tip_read;
int tiptest; //0-def; 1-if; 2-while


//---------------------------------------------------------------------------
__fastcall TForm6::TForm6(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm6::FormKeyPress(TObject *Sender, char &Key)
{
if (Key==27) Close();    
}

//---------------------------------------------------------------------------

void ReadVar(int loc, int tip, int &ival, float &fval)
{
if (tip==INT_TYPE) 
   {
   char *pvar;
   __int16 var;
   pvar=(char *) &var;
   pvar[0]=memory[loc]; pvar[1]=memory[loc+1];
   ival = var;
   }
else //Real
   {
   char *pvar;
   float var;
   pvar=(char *) &var;
   pvar[0]=memory[loc]; pvar[1]=memory[loc+1];
   pvar[2]=memory[loc+2]; pvar[3]=memory[loc+3];
   fval = var;
   }
}

//---------------------------------------------------------------------------

void WriteVar(int loc, int tip, int ival, float fval)
{
if (tip==INT_TYPE) 
   {
   char *pvar;
   __int16 var;
   pvar=(char *) &var;
   var = ival;
   memory[loc]=pvar[0]; memory[loc+1]=pvar[1];
   }
else //Real
   {
   char *pvar;
   float var;
   pvar=(char *) &var;
   var = fval;
   memory[loc]=pvar[0]; memory[loc+1]=pvar[1];
   memory[loc+2]=pvar[2]; memory[loc+3]=pvar[3];
   }
}

//---------------------------------------------------------------------------

void EvaluareExpresie(TTreeNode *Nod, int &type, int &ival, float &fval)
{
int i_val; float f_val;
AnsiString msg,as;

if (Nod->Text.SubString(1,2)=="Id")
     {
     msg = Nod->Text.SubString(5,100);
     int memloc = st_lookup(msg.c_str(),type);
     if (memloc!=-1)
        ReadVar(memloc, type, ival, fval);
     }

else if (Nod->Text.SubString(1,2)=="Op")
     {
     msg = Nod->Text.SubString(5,100);
     float opd1, opd2; int iopd1, iopd2;
     int tip1, tip2;
     TTreeNode *Nod1, *Nod2;

     Nod1 = Nod->getFirstChild();
     Nod2 = Nod->GetNextChild(Nod1);

     EvaluareExpresie(Nod1, tip1, iopd1, opd1);

     if (Nod2 != NULL) EvaluareExpresie(Nod2, tip2, iopd2, opd2);
     else {
          opd2=opd1; tip2=tip1; opd1=0;
          iopd2=iopd1; iopd1=0;
          }   // - (operator unar): (- nr)

     if (tip1==INT_TYPE) opd1=iopd1;
     if (tip2==INT_TYPE) opd2=iopd2;

     type=INT_TYPE; 
     if (tip1==REAL_TYPE || tip2==REAL_TYPE) type=REAL_TYPE;

     if (msg=="+") fval=opd1+opd2;
     else if (msg=="-") fval=opd1-opd2;
     else if (msg=="*") fval=opd1*opd2;

     else if (msg=="/")
          {
          if (opd2==0)
             {
             ShowMessage("Impartire la 0\nConventie: A/0 = A");
             fval=opd1; //conventie: A/0 = A
             }
          else fval=opd1/opd2;
          }

     else if (msg=="^")
          {
          if (opd1<0)
             {
             if (1./opd2/2. == (int)(1./opd2/2.))
                {
                ShowMessage("Eroare in radical\nConventie: (-A)^x = -(A^x)");
                fval=-pow(-opd1,opd2); //conventie: (-A)^x = -(A^x)
                }
             }
          else if (!opd1 && !opd2)
               {
               ShowMessage("Forma fara sens: 0 ^ 0\nConventie: 0 ^ 0 = 1");
               fval=1; //conventie: 0 ^ ) = 1
               }
          else fval=pow(opd1,opd2);
          }
     if (type==INT_TYPE) ival=(int)fval;
     }

else if (Nod->Text.SubString(1,5)=="Const")
     {
     msg = Nod->Text.SubString(8,100);
     strcpy(numar,msg.c_str());
     type=INT_TYPE;
     for (int i=0; numar[i]; i++)
         if (numar[i]=='.' || numar[i]==',')
            { type=REAL_TYPE; break; }
     (type==INT_TYPE) ? ival=atoi(numar) : fval=strtod(numar,NULL);
     }

else if (Nod->Text.SubString(1,4)=="Test")
     {
     msg = Nod->Text.SubString(7,100);
     float opd1, opd2; int iopd1, iopd2;
     int tip1, tip2;
     TTreeNode *Nod1, *Nod2;

     Nod1 = Nod->getFirstChild();
     if (Nod1 != NULL) Nod2 = Nod->GetNextChild(Nod1);

     if (Nod1 != NULL) EvaluareExpresie(Nod1, tip1, iopd1, opd1);
     if (Nod2 != NULL) EvaluareExpresie(Nod2, tip2, iopd2, opd2);

     if (tip1==INT_TYPE) opd1=iopd1;
     if (tip2==INT_TYPE) opd2=iopd2;

     switch (tiptest)
            {
            case 1: as="Test IF: "; break;
            case 2: as="Test WHILE: "; break;
            default: as="Test: "; break;
            }

     (tip1==INT_TYPE) ? sprintf(numar,"%d",iopd1) : sprintf(numar,"%f",opd1);
     as+=numar;
     as+=" "; as+=msg; as+=" ";
     (tip2==INT_TYPE) ? sprintf(numar,"%d",iopd2) : sprintf(numar,"%f",opd2);
     as+=numar;

     type=INT_TYPE; //boolean (0/1)

     if (msg == "<") ival=(opd1<opd2);
     else if (msg == ">") ival=(opd1>opd2);
     else if (msg == "==") ival=( fabs(opd1-opd2) < 1e-5 );
     else if (msg == "<>") ival=!( fabs(opd1-opd2) < 1e-5 );

     if (!ival) as+=" (fals)";
     else as+=" (adevarat)";
     Form6->RichEdit1->SelAttributes->Color = clGray;
     Form6->RichEdit1->Lines->Add(as);
     }

(type==INT_TYPE) ? fval=ival : ival=(int)fval;   //copierea rezultatului in ambele variabile

}

//---------------------------------------------------------------------------

void ParcurgereArbore(TTreeNode *Nod)
{
AnsiString msg, as;
int type=INT_TYPE, ival=0; float fval=0;

tiptest=0;

if (Nod->Text.SubString(1,4)=="Read")
   {
   msg = Nod->Text.SubString(7,100);
   int memloc = st_lookup(msg.c_str(),tip_read);
   if (memloc!=-1)
      {
      capt=msg; Form7->ShowModal();
      as="Read: "; as+=msg; as+=" = ";
      (tip_read==INT_TYPE) ? sprintf(numar,"%d",ival_read) : sprintf(numar,"%f",fval_read);
      as+=numar;
      Form6->RichEdit1->SelAttributes->Color = clBlue;
      Form6->RichEdit1->Lines->Add(as);
      WriteVar(memloc, tip_read, ival_read, fval_read);
      }
   }

else if (Nod->Text.SubString(1,5)=="Write")
     {
     EvaluareExpresie(Nod->getFirstChild(), type, ival, fval);
     as="Write: ";
     (type==INT_TYPE) ? sprintf(numar,"%d",ival) : sprintf(numar,"%f",fval);
     as+=numar;
     Form6->RichEdit1->SelAttributes->Color = clRed;
     Form6->RichEdit1->Lines->Add(as);
     }

else if (Nod->Text.SubString(1,6)=="Assign")
     {
     int tip;
     msg = Nod->Text.SubString(12,100);
     EvaluareExpresie(Nod->getFirstChild(), type, ival, fval);
     int memloc = st_lookup(msg.c_str(),tip);
     if (memloc!=-1) WriteVar(memloc, tip, ival, fval);
     as=msg; as+=" = ";
     (tip==INT_TYPE) ? sprintf(numar,"%d",ival) : sprintf(numar,"%f",fval);
     as+=numar;
     Form6->RichEdit1->SelAttributes->Color = clBlack;
     Form6->RichEdit1->Lines->Add(as);
     }

else if (Nod->Text.SubString(1,2)=="If")
     {
     TTreeNode *NodTest, *NodThen, *NodElse;
     NodTest = Nod->getFirstChild();
     NodThen = Nod->GetNextChild(NodTest);
     NodElse = Nod->GetNextChild(NodThen);

     tiptest=1;
     EvaluareExpresie(NodTest, type, ival, fval);
     if (ival) ParcurgereArbore(NodThen->getFirstChild());
     else if (NodElse!=NULL) ParcurgereArbore(NodElse->getFirstChild());
     }

else if (Nod->Text.SubString(1,5)=="While")
     {
     TTreeNode *NodTest, *NodDo;
     NodTest = Nod->getFirstChild();
     if (NodTest!=NULL) NodDo = Nod->GetNextChild(NodTest);

     Form6->RichEdit1->SelAttributes->Color = clGreen;
     Form6->RichEdit1->Lines->Add("Bucla WHILE");

     while (1)                                                 
           {
           tiptest=2;
           if (NodTest!=NULL) EvaluareExpresie(NodTest, type, ival, fval);
           if (!ival) break;
           if (NodDo!=NULL) ParcurgereArbore(NodDo->getFirstChild());
           }

     Form6->RichEdit1->SelAttributes->Color = clGreen;
     Form6->RichEdit1->Lines->Add("Sfarsit bucla WHILE");

     }

else if (Nod->Text.SubString(1,3)=="For")
     {
     TTreeNode *NodAssign, *NodTo, *NodStep, *NodDo;
     AnsiString numevar;
     int ilim=0, ipas=0; float flim=0, fpas=0;
     int tiplim=INT_TYPE, tippas=INT_TYPE;

     NodAssign = Nod->getFirstChild();
     NodTo = Nod->GetNextChild(NodAssign);
     NodStep = Nod->GetNextChild(NodTo);
     NodDo = Nod->GetNextChild(NodStep);

     Form6->RichEdit1->SelAttributes->Color = clGreen;
     Form6->RichEdit1->Lines->Add("Bucla FOR");

     ParcurgereArbore(NodAssign); numevar = NodAssign->Text.SubString(12,100);
     EvaluareExpresie(NodTo->getFirstChild(), type, ival, fval);
     tiplim = type; (type==INT_TYPE) ? ilim = ival : flim = fval;
     EvaluareExpresie(NodStep->getFirstChild(), type, ival, fval);
     tippas = type; (type==INT_TYPE) ? ipas = ival : fpas = fval;

     while (1)
           {
           //test: contor < limita
           int memloc = st_lookup(numevar.c_str(),type);
           //int i_val=0; float f_val=0;
           if (memloc!=-1) ReadVar(memloc, type, ival, fval);
           as="Test FOR: ";
           (type==INT_TYPE) ? sprintf(numar,"%d",ival) : sprintf(numar,"%f",fval);
           as+=numar; as+=" <= ";
           (tiplim==INT_TYPE) ? sprintf(numar,"%d",ilim) : sprintf(numar,"%f",flim);
           as+=numar;

           float real_var=0, real_lim=0, real_pas=0;
           (type==INT_TYPE) ? real_var=ival : real_var=fval;
           (tiplim==INT_TYPE) ? real_lim=ilim : real_lim=flim;
           (tippas==INT_TYPE) ? real_pas=ipas : real_pas=fpas;

           if (real_var > real_lim) as+=" (fals)";
           else as+=" (adevarat)";
           Form6->RichEdit1->SelAttributes->Color = clGray;
           Form6->RichEdit1->Lines->Add(as);

           if (real_var > real_lim) break;

           //actiuni
           ParcurgereArbore(NodDo->getFirstChild());

           //actualizare contor
           ival+=real_pas; fval+=real_pas;
           if (memloc!=-1) WriteVar(memloc, type, ival, fval);
           as=numevar; as+=" = ";
           (type==INT_TYPE) ? sprintf(numar,"%d",ival) : sprintf(numar,"%f",fval);
           as+=numar;
           Form6->RichEdit1->SelAttributes->Color = clBlack;
           Form6->RichEdit1->Lines->Add(as);
           }

     Form6->RichEdit1->SelAttributes->Color = clGreen;
     Form6->RichEdit1->Lines->Add("Sfarsit bucla FOR");
     }




if ( (Nod->getNextSibling()) != NULL)
   ParcurgereArbore(Nod->getNextSibling());

}

//---------------------------------------------------------------------------

void __fastcall TForm6::FormActivate(TObject *Sender)
{
RichEdit1->Clear();
ParcurgereArbore(Form4->TreeView1->Items->Item[0]);
}

//---------------------------------------------------------------------------

void __fastcall TForm6::RichEdit1KeyPress(TObject *Sender, char &Key)
{
if (Key==27) Close();
}

//---------------------------------------------------------------------------



