using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace ExtendedRandomTest
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.RichTextBox richTextBox1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			InitializeComponent();

			rand = new ExtRandom();
			d = Distribution.Uniform;
			SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.DoubleBuffer | ControlStyles.UserPaint, true);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.richTextBox1 = new System.Windows.Forms.RichTextBox();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem2,
																					  this.menuItem3,
																					  this.menuItem4});
			this.menuItem1.Text = "Distribution";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.Shortcut = System.Windows.Forms.Shortcut.F1;
			this.menuItem2.Text = "Uniform";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.Shortcut = System.Windows.Forms.Shortcut.F2;
			this.menuItem3.Text = "Normal";
			this.menuItem3.Click += new System.EventHandler(this.menuItem3_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 2;
			this.menuItem4.Shortcut = System.Windows.Forms.Shortcut.F3;
			this.menuItem4.Text = "Exponential Negative";
			this.menuItem4.Click += new System.EventHandler(this.menuItem4_Click);
			// 
			// richTextBox1
			// 
			this.richTextBox1.Dock = System.Windows.Forms.DockStyle.Right;
			this.richTextBox1.Location = new System.Drawing.Point(672, 0);
			this.richTextBox1.Name = "richTextBox1";
			this.richTextBox1.ReadOnly = true;
			this.richTextBox1.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.None;
			this.richTextBox1.Size = new System.Drawing.Size(256, 337);
			this.richTextBox1.TabIndex = 0;
			this.richTextBox1.Text = "";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(928, 337);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.richTextBox1});
			this.Menu = this.mainMenu1;
			this.Name = "Form1";
			this.Text = "Randoms";
			this.Paint += new System.Windows.Forms.PaintEventHandler(this.Form1_Paint);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private enum Distribution
		{
			Uniform, Normal, ExpNeg
		}

		private Distribution d;
		private ExtRandom rand;
		private const int max = 500;
		private const int simNumber = 25000;


		private void Form1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			int[] mat = new int[max];

			e.Graphics.DrawLine(new Pen(Color.Blue), 100, 10, 100, 300);
			e.Graphics.DrawLine(new Pen(Color.Blue), 100+max, 10, 100+max, 300);
			e.Graphics.DrawLine(new Pen(Color.Blue), 100+max/2, 10, 100+max/2, 300);

			e.Graphics.DrawLine(new Pen(Color.Green), 100+max/4, 10, 100+max/4, 300);
			e.Graphics.DrawLine(new Pen(Color.Green), (int)(100+max*0.75), 10, (int)(100+max*0.75), 300);
			
			if (this.d == Distribution.Uniform)
			{
				for (int i=0; i<simNumber; i++)
				{
					int nr = rand.Next(max);
					mat[nr]++;
				}
			}
			if (this.d == Distribution.Normal)
			{
				for (int i=0; i<simNumber; i++)
				{
					int nr = (int)rand.NextNormal(max/2, 50);
					if (nr>=0 && nr<max)
						mat[nr]++;
				}
			}
			if (this.d == Distribution.ExpNeg)
			{
				for (int i=0; i<simNumber; i++)
				{
					int nr = (int)(rand.NextExpNeg(5) * max);
					if (nr>=0 && nr<max)
						mat[nr]++;
				}
			}


			for (int i=0; i<max; i++)
				e.Graphics.DrawLine(new Pen(Color.Black), i+100, 300, i+100, 300-mat[i]);
			
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			d = Distribution.Uniform;
			this.Refresh();

			richTextBox1.Clear();
			for (int i=0; i<20; i++)
			{
				double nr = rand.NextDouble() * max;
				richTextBox1.AppendText(nr.ToString() + "\r\n");
			}

		}

		private void menuItem3_Click(object sender, System.EventArgs e)
		{
			d = Distribution.Normal;
			this.Refresh();

			richTextBox1.Clear();
			for (int i=0; i<20; i++)
			{
				double nr = rand.NextNormal(max/2, 50);
				richTextBox1.AppendText(nr.ToString() + "\r\n");
			}

		}

		private void menuItem4_Click(object sender, System.EventArgs e)
		{
			d = Distribution.ExpNeg;
			this.Refresh();		

			richTextBox1.Clear();
			for (int i=0; i<20; i++)
			{
				double nr = rand.NextExpNeg(5) * max;
				richTextBox1.AppendText(nr.ToString() + "\r\n");
			}

		}
	}
}
