/**************************************************************************
 *                                                                        *
 *  File:        Unit1.cpp                                                *
 *  Copyright:   (C) 2002, Florin Leon                                    *
 *  E-mail:      florinleon@yahoo.com                                     *
 *  Website:     http://www.angelfire.com/home/florinleon                 *
 *  Description: A program editor with syntax highlight and function      *
 *               auto-complete.                                           *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 1, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program; if not, write to the Free Software           *
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                        *
 **************************************************************************/

#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
#pragma package(smart_init)
#pragma resource "*.dfm"

#define XM PaintBox1->Width
#define YM PaintBox1->Height

TForm1 *Form1;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
    maxpos=0;
    nrkw=0;
    nrf=0;
    nrlines=1;
    scrollfrom=0;
    selfct=-1;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Exit1Click(TObject *Sender)
{
    Close();
}

//---------------------------------------------------------------------------

int TForm1::IsSeparator(char c)
{
    if (!c) return 0;

	char sep[]=" ,;.{}()+-*/#<>=%^&\n\r";

	for (int i=0; i<sizeof sep; i++)
        if (c==sep[i]) return 1;
    return 0;
}

//---------------------------------------------------------------------------

void TForm1::GetNextWord(char *dest, char *str, int &offset)
{
    int j;
    if (offset==-1) return;

    if (IsSeparator(str[offset]) )
    {
        if (str[offset]=='/' && str[offset+1]=='/')
        {
            dest[0] = str[offset++];
            dest[1] = str[offset++];
            dest[2] = 0;
        }
        else
        {
            dest[0] = str[offset++];
            dest[1] = 0;
        }
        return;
    }

    for (j=offset; str[j] && !IsSeparator(str[j]); j++)
        dest[j-offset] = str[j];

    dest[j-offset]=0;

    if (!str[j]) offset=-1;
    else offset = j;
}

//---------------------------------------------------------------------------

void TForm1::AnalyzeArguments(char *a1, char *a2, char *a3)
{
    int argsleft = selarg, offset=0;
    char fname[100], tempstr[100];

    strcpy(fname, functions[selfct].c_str());

    // tip
    while (1)
    {
        GetNextWord(tempstr, fname, offset);
        if (tempstr[0]!=' ' || offset==-1)
            break;
    }

    strcpy(a1, tempstr);

    // nume
    while (1)
    {
        GetNextWord(tempstr, fname, offset);
        if (tempstr[0]!=' ' || offset==-1)
            break;
    }

    strcat(a1, " ");
    strcat(a1, tempstr);

    while (1)
    {
        GetNextWord(tempstr, fname, offset);
        if (tempstr[0]=='(' || offset==-1)
            break;
    }

    strcat(a1, "(");

    while (argsleft && offset!=-1)
    {
        GetNextWord(tempstr, fname, offset);
        if (tempstr[0] == ',') argsleft--;
        if (tempstr[0]!='(')
            strcat(a1, tempstr);
    }

    strcpy(a2, "");
    strcpy(a3, "");

    while (!argsleft && offset!=-1)
    {
        int toff = offset;
        GetNextWord(tempstr, fname, offset);
        if (!strcmp(tempstr, "void"))
        {
            strcpy(a1, fname);
            return;
        }
        if (tempstr[0] == ',' || tempstr[0] == ')')
        {
            argsleft--;
            offset = toff;
            break;
        }
        strcat(a2, tempstr);
    }

    while (offset!=-1)
    {
        GetNextWord(tempstr, fname, offset);
        strcat(a3, tempstr);
    }

}

//---------------------------------------------------------------------------


void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
    OffScreenImage->Canvas->Pen->Color = clWhite;
    OffScreenImage->Canvas->Brush->Color = clWhite;
    OffScreenImage->Canvas->Rectangle(0,0, XM, YM);

    OffScreenImage->Canvas->Font->Name = "Courier New";
    OffScreenImage->Canvas->Font->Size = 10;
    int dy = OffScreenImage->Canvas->TextHeight("Yq");

    int x=4,y=4;
    bool iskeyword=false, iscomment=false;
    char tempstr[100];

    int offset = lines[scrollfrom];

    while (offset != -1)
    {
        GetNextWord(tempstr, buffer, offset);
        if (tempstr[0] == '\n') continue;

        AnsiString word = tempstr;
        iskeyword = false;
        for (int i=0; i<nrkw; i++)
            if (word == keywords[i])
            {
                iskeyword = true;
                break;
            }

        if (word=="//") iscomment=true;

        if (tempstr[0] == '\r')
        {
            x=4;
            y+=dy;
            iscomment=false;
        }
        else
        {
            if (iscomment)
            {
                OffScreenImage->Canvas->Font->Style =
                    OffScreenImage->Canvas->Font->Style >> fsBold;
                OffScreenImage->Canvas->Font->Color = clBlue;
            }

            else
            {
                OffScreenImage->Canvas->Font->Color = clBlack;

                if (iskeyword)
                    OffScreenImage->Canvas->Font->Style =
                        OffScreenImage->Canvas->Font->Style << fsBold;
                else
                    OffScreenImage->Canvas->Font->Style =
                        OffScreenImage->Canvas->Font->Style >> fsBold;
            }

            OffScreenImage->Canvas->TextOut(x, y, word);
            x += OffScreenImage->Canvas->TextWidth(word);
        }
    }

    OffScreenImage->Canvas->Pen->Color = clBlack;
    OffScreenImage->Canvas->MoveTo(x+1, y);
    OffScreenImage->Canvas->LineTo(x+1, y+dy);

    if (selfct != -1)
    {
        OffScreenImage->Canvas->Font->Name = "Arial";
        OffScreenImage->Canvas->Font->Size = 8;
        int th = OffScreenImage->Canvas->TextHeight("Yq");

        char a1[100], a2[100], a3[100];
        AnalyzeArguments(a1, a2, a3);

        OffScreenImage->Canvas->Font->Style = OffScreenImage->Canvas->Font->Style >> fsBold;
        int tw1 = OffScreenImage->Canvas->TextWidth(a1);
        OffScreenImage->Canvas->Font->Style = OffScreenImage->Canvas->Font->Style << fsBold;
        int tw2 = OffScreenImage->Canvas->TextWidth(a2);
        OffScreenImage->Canvas->Font->Style = OffScreenImage->Canvas->Font->Style >> fsBold;
        int tw3 = OffScreenImage->Canvas->TextWidth(a3);

        int tw=tw1+tw2+tw3;

        OffScreenImage->Canvas->Pen->Color = clBlack;
        OffScreenImage->Canvas->Brush->Color = 0xDDFBFB;
        OffScreenImage->Canvas->Rectangle(x+1, y+dy+2, x+1+tw+6, y+dy+2+th+6);

        OffScreenImage->Canvas->Font->Color = clBlack;
        OffScreenImage->Canvas->Font->Style = OffScreenImage->Canvas->Font->Style >> fsBold;
        OffScreenImage->Canvas->TextOut(x+4, y+dy+5, a1);

        OffScreenImage->Canvas->Font->Color = clNavy;
        OffScreenImage->Canvas->Font->Style = OffScreenImage->Canvas->Font->Style << fsBold;
        OffScreenImage->Canvas->TextOut(x+4+tw1, y+dy+5, a2);

        OffScreenImage->Canvas->Font->Color = clBlack;
        OffScreenImage->Canvas->Font->Style = OffScreenImage->Canvas->Font->Style >> fsBold;
        OffScreenImage->Canvas->TextOut(x+4+tw1+tw2+2, y+dy+5, a3);

    }

    OffScreenImage->Canvas->Pen->Color = clBlack;
    OffScreenImage->Canvas->MoveTo(0,0);
    OffScreenImage->Canvas->LineTo(XM-1,0);
    OffScreenImage->Canvas->LineTo(XM-1,YM-1);
    OffScreenImage->Canvas->LineTo(0,YM-1);
    OffScreenImage->Canvas->LineTo(0,0);

    PaintBox1->Canvas->Draw(0,0,OffScreenImage);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
    if (Key == '\b' && maxpos > 0) // 8=backspace
    {
        if (buffer[maxpos-1]=='\n')
        {
            nrlines--;
            maxpos--;
        }
        else if (buffer[maxpos-1]==',')
            selarg--;
        else if (buffer[maxpos-1]=='(')
            selfct=-1;

        maxpos--;
        ScrollBar2Change(this);
    }

    else if (Key=='\r')  // 13=enter
    {
        buffer[maxpos++] = '\r';   //  13
        buffer[maxpos++] = '\n';   //  10
        lines[nrlines++] = maxpos;
        ScrollBar2->Position = ScrollBar2->Max;
        ScrollBar2Change(this);
    }

    else if (Key=='(')
    {
        int start_fname=maxpos, i, j;

        for (i=maxpos; ; i--)
            if (IsSeparator(buffer[i]) || i<0)
            {
                start_fname = i+1;
                break;
            }

        buffer[maxpos++] = Key;

        char tempstr[100];
        GetNextWord(tempstr, buffer, start_fname);
        AnsiString fname=tempstr;

        for (i=0; i<nrf; i++)
        {
            for (j=0; j<functions[i].Length() && functions[i].c_str()[j]!=' '; j++);
            for (; j<functions[i].Length() && functions[i].c_str()[j]==' '; j++);
            GetNextWord(tempstr, functions[i].c_str(), j);

            if (fname == (AnsiString)tempstr)
            {
                selfct=i;
                selarg=0;
                break;
            }
        }
    }

    else if (Key==27)   // ESC
        selfct=-1;

    else if (Key==')')
    {
        buffer[maxpos++] = Key;
        selfct=-1;
    }

    else if (Key==',')
    {
        buffer[maxpos++] = Key;
        selarg++;
    }

    else if (Key>=' ' && Key<='~')   // caracter afisabil
        buffer[maxpos++] = Key;

    buffer[maxpos]=0;
    PaintBox1Paint(this);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
    OffScreenImage = new Graphics::TBitmap;
    OffScreenImage->Width = XM;
    OffScreenImage->Height = YM;

    Memo1->Lines->LoadFromFile("keywords.txt");
    nrkw = Memo1->Lines->Count;
    for (int i=0; i<nrkw; i++)
        keywords[i] = Memo1->Lines->Strings[i];

    Memo1->Lines->LoadFromFile("functions.txt");
    nrf = Memo1->Lines->Count;
    for (int i=0; i<nrf; i++)
        functions[i] = Memo1->Lines->Strings[i];

    lines[0]=0;
    nrlines=1;
    selfct=-1;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormResize(TObject *Sender)
{
    OffScreenImage->Width = XM;
    OffScreenImage->Height = YM;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::New1Click(TObject *Sender)
{
    buffer[0]=0;
    maxpos = 0;
    nrlines=1;
    scrollfrom=0;
    selfct=-1;
    PaintBox1Paint(this);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Open1Click(TObject *Sender)
{
    if (OpenDialog1->Execute())
    {
        Memo1->Lines->LoadFromFile(OpenDialog1->FileName);
        strcpy(buffer, Memo1->Text.c_str());
        maxpos = Memo1->Text.Length();
        PaintBox1Paint(this);
    }

    int selfct=-1;
    nrlines=1;
    for (int i=0; i<maxpos; i++)
    {
        if (buffer[i]=='\r')  // 13=enter
            lines[nrlines++] = i+2;
        if (buffer[i]=='\t')  // tab
            buffer[i]=' ';
    }
    ScrollBar2->Position = ScrollBar2->Min;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Save1Click(TObject *Sender)
{
    if (SaveDialog1->Execute())
    {
        buffer[maxpos]=0;
        Memo1->Text = buffer;
        Memo1->Lines->SaveToFile(SaveDialog1->FileName);
        PaintBox1Paint(this);
    }
}

//---------------------------------------------------------------------------

void __fastcall TForm1::ScrollBar2Change(TObject *Sender)
{
    PaintBox1->Canvas->Font->Name = "Courier New";
    PaintBox1->Canvas->Font->Size = 10;
    int dy = PaintBox1->Canvas->TextHeight("Yq");

    int nrl = PaintBox1->Height / dy;

    if (nrl > nrlines)
        scrollfrom = 0;
    else
    {
        scrollfrom = ScrollBar2->Position * (nrlines+1 - nrl) / ScrollBar2->Max;
        PaintBox1Paint(this);
    }
}

//---------------------------------------------------------------------------
