//*****************************************************************************
//
//		Client ftp pt socketuri TCP/IP
//
//	Comenzi implementate:
//		ls
//		get <nume_fisier>
//		put <nume_fisier>
//		cd - afiseaza directorul curent
//		cd <cale> - schimba directorul curent
//		
//*****************************************************************************

#include <stdio.h> 
#include <stdlib.h> 
#include <errno.h> 
#include <string.h> 
#include <netdb.h> 
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h> 
#include <sys/wait.h>
#include <netinet/in.h> 
#include <sys/socket.h> 

#define COMMANDPORT 21   

#define MAXDATASIZE 0x200 



char hn[60];      // Host name
char port[60];    // Data port
int myport; 	  // Acelasi dar convertit la intreg
int data=0; 	  // Pentru comenzi cu date


//************************ Create Client Socket & Connect *********************

int CreateClientSocket(char *host)
{
int sockfd;  
struct hostent *he; 
struct sockaddr_in their_addr; 
if ((he=gethostbyname(host)) == NULL) 
   {
   
   herror("gethostbyname"); 
   exit(1); 
   }

if ((sockfd = socket(PF_INET, SOCK_STREAM, 0)) == -1) 
   {
   perror("socket"); 
   exit(1); 
   }

their_addr.sin_family = PF_INET;    
their_addr.sin_port = htons(COMMANDPORT);  
their_addr.sin_addr = *((struct in_addr *)he->h_addr); 
bzero(&(their_addr.sin_zero), 8);   

if (connect(sockfd, (struct sockaddr *)&their_addr, \
   sizeof(struct sockaddr)) == -1) 
   {
   perror("connect"); 
   exit(1); 
   }
return sockfd; 
}

//********************** Create Server Socket & Listen ************************

int CreateServerSocket()
{
int sockfd; 
struct sockaddr_in my_addr; 
char temp[20]; 
int sin_size; 

if ((sockfd = socket(PF_INET, SOCK_STREAM, 0)) == -1) 
   {
   perror("socket"); 
   exit(1); 
   }

my_addr.sin_family = PF_INET;    
my_addr.sin_port = 0 ;         // primul port liber 
my_addr.sin_addr.s_addr =  INADDR_ANY;  
bzero(&(my_addr.sin_zero), 8);   

sin_size = sizeof(struct sockaddr); 

if ( bind(sockfd, (struct sockaddr *) &my_addr, sin_size) == -1)
   {
   perror("bind"); 
   exit(1); 
   }
// Vreau sa vad ce port mi-a dat
if ( getsockname(sockfd, (struct sockaddr *) &my_addr, &sin_size) == -1)
   {
   perror("getsockname"); 
   exit(1); 
   }

myport = ntohs(my_addr.sin_port); 

if ( listen(sockfd,10) == -1)
   {
   perror("listen"); 
   exit(1); 
   }

return sockfd; 
}    


void ReadFromSocket(int sock, char *s, int size)
// Functie de citire a raspunsurilor pe portul de comenzi
{
int len,i=0,col=0,lin=1; 
char c; 
do 
   {
   len = read(sock,&c,1); 
   s[i++] = c; 
   if (c == '\n')
      col = -1; 
   if (col == 3)
      {
      if (c == '-')
         lin = 1; 
      else 
         lin = 0; 
      }
   col++; 
   }
while(c !=  '\n' | lin == 1); 
s[i] = '\0'; 
}

int ParseAnswer(char *s)
// Analizez raspunsul primit
{
int code; 
char temp[4]; 
strncpy(temp,s,3); 
temp[3] = '\0'; 
code = atoi(temp); 
switch (code)  // Daca vreau sa personalizez mesajele primite de la server
       {
       case 530:
                 printf("* Not logged yet\n"); 
                 break; 
       default:
                 printf("%s",s); 
       }
return code; 
}

int ParseCommand(char *s)
// Interpreteaza comanda si intoarce un cod
{
int code=0; 
char temp[20]; 
char* c; 
if ( !strncmp(s,"ls",2))
   {
   data = 1; 
   code = 1; 
   strncpy(s,"LIST\n",6); 
   }
if ( !strncmp(s,"get",2))
   {
   data = 1; 
   code = 2; 
   c=temp; 
   strcpy(temp,s); 
   strncpy(s,"RETR",4); 
   strcpy(s+4,c+3); 
   }
if ( !strncmp(s,"put",2))
   {
   data = 1; 
   code = 3; 
   c=temp; 
   strcpy(temp,s); 
   strncpy(s,"STOR",4); 
   strcpy(s+4,c+3); 
   }
if ( !strncmp(s,"cd",2))
   {
   code = 4; 
   if ( strlen(s) > 4)
      {
      c=temp; 
      strcpy(temp,s); 
      strncpy(s,"CWD",3); 
      strcpy(s+3,c+2); 
      }
   else 
      strncpy(s,"PWD\n",5); 
   }
if ( !strncmp(s,"by",2))
   {
   code = 10; 
   strncpy(s,"QUIT\n",6); 
   }
return code; 
}

//******************************* Main body **********************************

int main(int argc, char *argv[])
{
char buf[MAXDATASIZE]; 
char buf1[MAXDATASIZE]; 
struct sockaddr_in their_addr; 
char uname[20]; 
char* pass; 
char* t; 
char* u; 
char c; 
int code,fd,a,b; 
int CommandSocket, DataSocket, TempSocket, numbytes, size; 
struct hostent *he; 


if (argc != 2) 
   {
   fprintf(stderr,"usage: %s hostname\n", argv[0]); 
   exit(1); 
   }
strcpy(buf,argv[1]); 

t = getenv("HOSTNAME"); 
if ((he=gethostbyname(t)) == NULL) 
   {
   
   herror("gethostbyname"); 
   exit(1); 
   }
strcpy(hn,t); 
t = inet_ntoa(*(struct in_addr* )he->h_addr); 
u=t; 
do 
   {
   if (*t == '.')
      *t = ','; 
   }
while(*t++ != '\0'); 
strcpy(hn,u); 

CommandSocket = CreateClientSocket(buf); 

// Getting first data    
ReadFromSocket(CommandSocket,buf,MAXDATASIZE);    
ParseAnswer(buf); 

// Logging in
printf("Name : "); 
fgets(uname,20,stdin); 
sprintf(buf,"USER %s",uname); 
numbytes = strlen(buf); 
send(CommandSocket,buf,numbytes,0); 
ReadFromSocket(CommandSocket,buf,MAXDATASIZE);    
if ( ParseAnswer(buf) == 331)
   {
   
   pass = getpass("Password :"); 
   sprintf(buf,"PASS %s",pass); 
   numbytes = strlen(buf); 
   buf[numbytes]='\n'; 
   send(CommandSocket,buf,numbytes+1,0); 
   ReadFromSocket(CommandSocket,buf,MAXDATASIZE);    
   if ( ParseAnswer(buf) != 230)
      {
      printf("Unknown user or wrong password\n"); 
      exit(1); 
      }
   } 

// Main reading writing part

while (1)
      {
      buf[0] = '\n'; 
      while (buf[0] == '\n')
            {
            printf("ftp> "); 
            fgets(buf,MAXDATASIZE,stdin); 
            }
      code = ParseCommand(buf); 
      if (data)
         {
         data = 0; 
         
         DataSocket = CreateServerSocket(); 
         a = myport/256; 
         b = myport%256; 
         sprintf(port,"PORT %s,%d,%d",hn,a,b); 
         numbytes = strlen(port); 
         port[numbytes] = '\n'; 
         
         numbytes = strlen(port); 
         send(CommandSocket,port, numbytes,0); 
         ReadFromSocket(CommandSocket,buf1,MAXDATASIZE);    
         if ( ParseAnswer(buf1) != 200)
            exit(1); 
         
         numbytes = strlen(buf); 
         send(CommandSocket,buf,numbytes,0); 
         
         ReadFromSocket(CommandSocket,buf1,MAXDATASIZE); 
         if (ParseAnswer(buf1) == 150)
            {
            size = sizeof(            struct sockaddr_in); 
            if ((TempSocket = accept(DataSocket, \
(struct sockaddr *) &their_addr,&size )) == -1)
               {
               perror("accept"); 
               exit(1); 
               }
            if (code == 1)      // receiving list
               {
               while (1)
                     {
                     numbytes = read(TempSocket,&c,1); 
                     if (numbytes == 0)
                        break; 
                     printf("%c",c); 
                     } 
               }    
            if (code == 2)      // receiving file
               {
               numbytes = strlen(buf); 
               buf[numbytes-1]='\0'; 
               fd = open(buf+5,O_WRONLY|O_CREAT|O_TRUNC,644); 
               if (fd == -1)
                  {
                  printf("open: file could not be created\n"); 
                  exit(1); 
                  }
               else 
                  {
                  while (1)
                        {
                        numbytes = read(TempSocket,&c,1); 
                        if (numbytes == 0)
                           break; 
                        write(fd,&c,1); 
                        } 
                  close(fd); 
                  }
               }    
            if (code == 3)   //  sending files
               {
               numbytes = strlen(buf); 
               buf[numbytes-1]='\0'; 
               fd = open(buf+5,O_RDONLY); 
               if (fd == -1)
                  {
                  printf("open:file does not exists or permission denied\n"); 
                  exit(1); 
                  }
               while (1)
                     {
                     numbytes = read(fd,buf,MAXDATASIZE-1); 
                     if (numbytes == 0)
                        break; 
                     write(TempSocket,buf,numbytes); 
                     }
               close(fd); 
               }
            close(TempSocket); 
            ReadFromSocket(CommandSocket,buf,MAXDATASIZE);    
            ParseAnswer(buf); 
            close(DataSocket); 
            }
         }
      else 
         {
         numbytes = strlen(buf); 
         send(CommandSocket,buf,numbytes,0); 
         
         ReadFromSocket(CommandSocket,buf,MAXDATASIZE);    
         if ( ParseAnswer(buf) == 221)
            break; 
         }
      }
close(CommandSocket); 
}