#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define DIM_MAX 512



char port[60]; 
int p1,data=0; 


int soclu_client(char *host)
{
int sfd; 
struct hostent *hstent; 
struct sockaddr_in adrs; 


if ((hstent=gethostbyname(host)) == NULL)
   {
   herror("gethostbyname"); exit(1); 
   }

if ((sfd = socket(AF_INET, SOCK_STREAM, 0)) == -1)
   {
   perror("socket"); exit(1); 
   }

adrs.sin_family = AF_INET; 
adrs.sin_port = htons(21);  //port de comanda
adrs.sin_addr = *((struct in_addr *)hstent->h_addr); 
bzero(&(adrs.sin_zero), 8); 

if (connect(sfd,(struct sockaddr *) &adrs,sizeof(struct sockaddr)) == -1)
   {
   perror("connect"); exit(1); 
   }

return sfd; 
}



int soclu_server()
{
int sfd,dim; 
struct sockaddr_in adrc; 
struct sockaddr_in adrs; 
struct hostent *hstent; 

if ((sfd = socket(AF_INET, SOCK_STREAM, 0)) == -1)
   {
   perror("socket"); exit(1); 
   }

adrc.sin_family = AF_INET; 
adrc.sin_port = 0 ;         // random port
adrc.sin_addr.s_addr =  INADDR_ANY; //inet_addr
bzero(&(adrc.sin_zero), 8); 

dim = sizeof(struct sockaddr); 

if (bind(sfd, (struct sockaddr *) &adrc, dim) == -1)
   {
   perror("bind"); exit(1); 
   }

if (getsockname(sfd, (struct sockaddr *) &adrc, &dim) == -1)
   {
   perror("getsockname"); exit(1); 
   }

p1=ntohs(adrc.sin_port); 

if (listen(sfd,10) == -1)
   {
   perror("listen"); exit(1); 
   }

return sfd; 
}



void citeste_soclu(int soc, char *s, int dim)
{
int lungmes; 

lungmes = recv(soc,s,dim,0); 
if (lungmes == -1)
   {
   perror("recv"); exit(1); 
   }
s[lungmes]='\0'; 
}



int interp_cod(char *sircod)
{
int cod; 
char c[4]; 

strncpy(c,sircod,3); 
c[3]='\0'; 
cod=atoi(c); 
switch (cod)
       {
       case 221:
                 printf("Iesire\n"); break; 
       case 230:
                 printf("V-ati conectat\n"); break; 
       case 331:
                 printf("Nume corect, introduceti parola\n"); break; 
       case 332:
                 printf("E necesar contul pentru conectare\n"); break; 
       case 425:
                 printf("Nu pot deschide conexiunea de date\n"); break; 
       case 452:
                 printf("Spatiu de stocare insuficient\n"); break; 
       case 500:
                 printf("Eroare de sintaxa in comanda\n"); break; 
       case 501:
                 printf("Eroare de sintaxa in parametri sau argumente\n"); break; 
       case 530:
                 printf("Nu v-ati conectat inca\n"); break; 
       case 532:
                 printf("E necesar contul pentru fisiere\n"); break; 
       case 553:
                 printf("Nume de fisier nepermis\n"); break; 
       default:
                 printf("%s",sircod); 
       }
return cod; 
}



int interp_cmd(char *sircmd)
{
int cod=0; 
char c[20]; 
char* s; 

if (!strncmp(sircmd,"ls",2))
   {
   data=1; cod=1; 
   strncpy(sircmd,"LIST\n",6); 
   }

if (!strncmp(sircmd,"get",2))
   {
   data=1; cod=2; 
   s=c; 
   strcpy(c,sircmd); 
   strncpy(sircmd,"RETR",4); 
   strcpy(sircmd+4,s+3); 
   }

if (!strncmp(sircmd,"put",2))
   {
   data=1; cod=3; 
   s=c; 
   strcpy(c,sircmd); 
   strncpy(sircmd,"STOR",4); 
   strcpy(sircmd+4,s+3); 
   }

if (!strncmp(sircmd,"cd",2))
   {
   cod=4; 
   if (strlen(sircmd) > 4)
      {
      s=c; 
      strcpy(c,sircmd); 
      strncpy(sircmd,"CWD",3); 
      strcpy(sircmd+3,s+2); 
      }
   else 
      strncpy(sircmd,"PWD\n",5); 
   }

if (!strncmp(sircmd,"by",2))
   {
   cod=5; 
   strncpy(sircmd,"QUIT\n",6); 
   }

return cod; 
}




int main()
{
char buffer1[DIM_MAX], buffer2[DIM_MAX]; 
struct sockaddr_in adrs; 
char nume[20],ipcl[60]; 
char *parola,*hostn,*t; 
int cod,file,ph,pl,scmd,sdata,s1,nroct,dim; 
struct hostent *hste; 

hostn=getenv("HOSTNAME"); 
if ((hste=gethostbyname(hostn)) == NULL)
   {
   herror("gethostbyname"); exit(1); 
   }
strcpy(ipcl,hostn); 
hostn=inet_ntoa(*(struct in_addr* )hste->h_addr); 
t=hostn; 
do 
   {
   if (*hostn == '.')
      *hostn = ','; 
   } while (*hostn++ != '\0'); 
strcpy(ipcl,t); 

printf("\nServer: "); 
fgets(buffer1,DIM_MAX,stdin); 
nroct = strlen(buffer1); 
buffer1[nroct-1] = '\0'; 
scmd=soclu_client(buffer1); 
sdata=soclu_server(); 

citeste_soclu(scmd,buffer1,DIM_MAX); // primele date
interp_cod(buffer1); 

printf("Nume: "); 
fgets(nume,20,stdin); 
sprintf(buffer1,"USER %s",nume); 
nroct=strlen(buffer1); 
send(scmd,buffer1,nroct,0); 
citeste_soclu(scmd,buffer1,DIM_MAX); 
if (interp_cod(buffer1) == 331)
   {
   parola=getpass("Parola: "); 
   sprintf(buffer1,"PASS %s",parola); 
   nroct=strlen(buffer1); 
   buffer1[nroct]='\n'; 
   send(scmd,buffer1,nroct+1,0); 
   citeste_soclu(scmd,buffer1,DIM_MAX); 
   if (interp_cod(buffer1) != 230)
      {
      printf("Utilizator necunoscut sau parola gresita\n"); exit(1); 
      }
   ph=p1/256; pl=p1%256; 
   sprintf(port,"PORT %s,%d,%d",ipcl,ph,pl); 
   nroct=strlen(port); 
   port[nroct]='\n'; 
   }

while (1)
      {
      buffer1[0]='\n'; 
      while (buffer1[0]=='\n')
            {
            printf("ftp> "); 
            fgets(buffer1,DIM_MAX,stdin); 
            }
      cod=interp_cmd(buffer1); 
      if (cod<4)
         {
         nroct=strlen(port); 
         send(scmd,port,nroct,0); 
         citeste_soclu(scmd,buffer2,DIM_MAX); 
         if (interp_cod(buffer2) != 200)
            exit(1); 
         }
      nroct=strlen(buffer1); 
      send(scmd,buffer1,nroct,0); 
      if (data)
         {
         data=0; 
         citeste_soclu(scmd,buffer2,DIM_MAX); 
         interp_cod(buffer2); 
         dim=sizeof(         struct sockaddr_in); 
         if ((s1=accept(sdata,(struct sockaddr *) &adrs,&dim)) == -1)
            {
            perror("accept"); exit(1); 
            }
         
         if (cod == 1)      // list
            {
            while (1)
                  {
                  nroct=read(s1,buffer1,DIM_MAX-1); 
                  if (!nroct) break; 
                  buffer1[nroct]='\0'; 
                  printf("%s",buffer1); 
                  }
            }
         if (cod == 2)      // get
            {
            nroct=strlen(buffer1); 
            buffer1[nroct-1]='\0'; 
            file=open(buffer1+5,O_WRONLY|O_CREAT|O_TRUNC,644); 
            if (file == -1)
               exit(1); 
            while (1)
                  {
                  nroct=read(s1,buffer1,DIM_MAX-1); 
                  if (!nroct) break; 
                  buffer1[nroct]='\0'; 
                  write(file,buffer1,nroct); 
                  }
            close(file); 
            }
         
         if (cod==3)   // put
            {
            nroct=strlen(buffer1); 
            buffer1[nroct-1]='\0'; 
            file=open(buffer1+5,O_RDONLY); 
            if (file == -1)
               exit(1); 
            while (1)
                  {
                  nroct=read(file,buffer1,DIM_MAX-1); 
                  if (!nroct) break; 
                  write(s1,buffer1,nroct); 
                  }
            close(file); 
            }
         
         close(s1); 
         close(sdata); 
         sdata=soclu_server(); 
         ph=p1/256; pl=p1%256; 
         sprintf(port,"PORT %s,%d,%d",ipcl,ph,pl); 
         nroct=strlen(port); 
         port[nroct]='\n'; 
         }
      
      citeste_soclu(scmd,buffer1,DIM_MAX); 
      if (interp_cod(buffer1) == 221)
         break; 
      }

close(scmd); 
close(sdata); 
}
