SET FEEDBACK OFF
DROP TABLE zboruri_posibile
/
CREATE TABLE zboruri_posibile
        (
	nrcrt NUMBER(4,0),
	idzbor NUMBER(5,0),
        plecare VARCHAR2(30),
        sosire VARCHAR2(30),
	distanta NUMBER(10),
	pret NUMBER(8,2),
	tplec NUMBER(6),
	tsos NUMBER(6)
        )
/
DECLARE
	CURSOR c1 IS 
		SELECT idzbor,ruta1,ruta2,sensr1,sensr2
		FROM zboruri;
	v_idzbor zboruri.idzbor%TYPE;
	v_ruta1 zboruri.ruta1%TYPE;
	v_ruta2 zboruri.ruta2%TYPE;
	v_s1 zboruri.sensr1%TYPE;
	v_s2 zboruri.sensr2%TYPE;
	v_plecare orase.nume%TYPE;
	v_escala orase.nume%TYPE;
	v_sosire orase.nume%TYPE;
	v_dist1 rute.dist%TYPE;
	v_dist2 rute.dist%TYPE;

	v_a orase.nume%TYPE;
	v_b orase.nume%TYPE;
	v_c orase.nume%TYPE;
	v_d orase.nume%TYPE;
	v_pret NUMBER(8,2);
	vp_pretul NUMBER(8,2);
	v_nr NUMBER(4);
	v_dur NUMBER(6);


FUNCTION calc_pret(vp_distanta IN NUMBER) RETURN NUMBER IS
BEGIN
	IF (vp_distanta <= 500) THEN
		vp_pretul := 15 + 0.05 * vp_distanta;
	ELSE 
		IF (vp_distanta <= 2000) THEN
			vp_pretul := 40 + 0.04 * (vp_distanta-500);
		ELSE 
			vp_pretul := 100 + 0.03 * (vp_distanta-2000);
		END IF;
	END IF;
	RETURN vp_pretul;
END;



BEGIN
	v_nr := 0;
	OPEN c1;
	LOOP
		FETCH c1 INTO v_idzbor, v_ruta1, v_ruta2, v_s1, v_s2;
		EXIT WHEN c1%NOTFOUND OR c1%NOTFOUND IS NULL;

		IF v_ruta2 IS NOT NULL THEN
			
			SELECT a.nume, b.nume, c.nume, d.nume, r1.dist, r2.dist
			INTO v_a, v_b, v_c, v_d, v_dist1, v_dist2
			FROM rute r1, rute r2, orase a, orase b, orase c, orase d
			WHERE r1.idruta=v_ruta1 AND
			      r2.idruta=v_ruta2 AND
			      a.idoras=r1.loc1 AND
			      b.idoras=r1.loc2 AND
			      c.idoras=r2.loc1 AND
			      d.idoras=r2.loc2;

			IF v_s1='D' THEN 
				v_plecare:=v_a;
				v_escala:=v_b;
			ELSE
				v_plecare:=v_b;
				v_escala:=v_a;
			END IF;
				
			IF v_s2='D' THEN
				v_sosire:=v_d;
			ELSE
				v_sosire:=v_c;
			END IF;
			   
			v_pret := calc_pret(v_dist1);
			v_nr := v_nr+1; v_dur := TRUNC(v_dist1*60/700,0);
			INSERT INTO zboruri_posibile (nrcrt, idzbor, plecare, sosire, distanta, pret, tplec, tsos)
				VALUES (v_nr, v_idzbor, v_plecare, v_escala, v_dist1, v_pret, 0, v_dur);

			v_pret := calc_pret(v_dist2);
			v_nr := v_nr+1; 
			INSERT INTO zboruri_posibile (nrcrt, idzbor, plecare, sosire, distanta, pret, tplec, tsos)
				VALUES (v_nr, v_idzbor, v_escala, v_sosire, v_dist2, v_pret, v_dur+30, v_dur+30+TRUNC(v_dist2*60/700,0));

			v_pret := calc_pret(v_dist1+v_dist2);
			v_nr := v_nr+1; v_dur := TRUNC((v_dist1+v_dist2)*60/700,0);
			INSERT INTO zboruri_posibile (nrcrt, idzbor, plecare, sosire, distanta, pret, tplec, tsos)
				VALUES (v_nr, v_idzbor, v_plecare, v_sosire, v_dist1+v_dist2, v_pret, 0, v_dur+30);

		ELSE

			SELECT a.nume, b.nume, r.dist
			INTO v_a, v_b, v_dist1
			FROM rute r, orase a, orase b
			WHERE r.idruta=v_ruta1 AND
			      a.idoras=r.loc1 AND
			      b.idoras=r.loc2;

			IF v_s1='D' THEN 
				v_plecare:=v_a;
				v_sosire:=v_b;
			ELSE
				v_plecare:=v_b;
				v_sosire:=v_a;
			END IF;

			v_pret := calc_pret(v_dist1);
			v_nr := v_nr+1; v_dur := TRUNC(v_dist1*60/700,0);
			INSERT INTO zboruri_posibile (nrcrt, idzbor, plecare, sosire, distanta, pret, tplec, tsos)
				VALUES (v_nr, v_idzbor, v_plecare, v_sosire, v_dist1, v_pret, 0, v_dur);

		END IF;
	END LOOP;
	CLOSE c1;
COMMIT;
END;
/
