SET FEEDBACK OFF
DROP TABLE temp_at
/
CREATE TABLE temp_at (info VARCHAR2(75))
/
SET VERIFY OFF
ACCEPT p_zb PROMPT 'Introduceti zborul: '

DECLARE
	vp_zbor NUMBER(5); 
	vp_datacrt DATE;
	vp_dataurm DATE;
	v_dc DATE;
	v_du DATE;
	v_text temp_at.info%TYPE;
	vp_nrzi NUMBER(2);
	vp_z locuri.zile%TYPE;
	vp_day VARCHAR2(3);
	vp_ora locuri.oraplec%TYPE;



FUNCTION urm_pl(vp_zbor IN NUMBER, vp_datacrt IN DATE) RETURN DATE IS
BEGIN
	vp_nrzi := TO_NUMBER(TO_CHAR(vp_datacrt,'D'))+6;

	SELECT zile, oraplec INTO vp_z, vp_ora
		FROM locuri
		WHERE vp_zbor=idzbor;

	FOR i IN vp_nrzi..vp_nrzi+7 LOOP

		IF i<>vp_nrzi OR
		vp_datacrt < TRUNC(vp_datacrt) + TRUNC(vp_ora,-2)/2400 + MOD(vp_ora,100)/1440 THEN
			IF i=vp_nrzi AND SUBSTR(vp_z,MOD(i-1,7)+1,1)='1' THEN
				vp_dataurm := vp_datacrt;
				EXIT;
			END IF;
			IF SUBSTR(vp_z,MOD(i-1,7)+1,1)='1' THEN
				IF    MOD(i-1,7)=0 THEN vp_day:='Mon';
				ELSIF MOD(i-1,7)=1 THEN vp_day:='Tue';
				ELSIF MOD(i-1,7)=2 THEN vp_day:='Wed';
				ELSIF MOD(i-1,7)=3 THEN vp_day:='Thu';
				ELSIF MOD(i-1,7)=4 THEN vp_day:='Fri';
				ELSIF MOD(i-1,7)=5 THEN vp_day:='Sat';
				ELSIF MOD(i-1,7)=6 THEN vp_day:='Sun';
				END IF;

				vp_dataurm := NEXT_DAY(vp_datacrt,vp_day);
				EXIT;
			END IF;
		END IF;
	END LOOP;

	vp_dataurm := TRUNC(vp_dataurm)+ TRUNC(vp_ora,-2)/2400 + MOD(vp_ora,100)/1440;

	RETURN vp_dataurm;
END;


BEGIN
	SELECT sysdate INTO v_dc FROM dual;	
	v_dc := v_dc - 2/24;  --ora Romaniei

	v_du := urm_pl(&p_zb,v_dc);
	v_text := TO_CHAR(v_du,'Dy, DD Mon YYYY, HH24:MI') || ' GMT';
	INSERT INTO temp_at (info) VALUES (v_text);
	COMMIT;

	EXCEPTION
		WHEN NO_DATA_FOUND THEN 
			DELETE FROM temp_at;
			INSERT INTO temp_at (info) VALUES ('Zborul nu exista');
			COMMIT;
			RETURN;
END;
/
SELECT * FROM temp_at
/
DROP TABLE temp_at
/
