SET FEEDBACK OFF
DROP TABLE temp_at;
DROP TABLE auto_tr;
CREATE TABLE temp_at (info VARCHAR2(75));
CREATE TABLE auto_tr
        (
        nrvar NUMBER(4), idz1 NUMBER(4), idz2 NUMBER(4), idz3 NUMBER(4), idz4 NUMBER(4)
        )
/
SET VERIFY OFF
ACCEPT p_plec PROMPT 'Introduceti orasul de plecare: '
ACCEPT p_sos PROMPT 'Introduceti orasul de sosire: '
VARIABLE rez_er NUMBER

DECLARE
	CURSOR c1 IS 
		SELECT a.nrcrt
		FROM zboruri_posibile a
		WHERE UPPER(plecare)=UPPER('&p_plec') AND
		      UPPER(sosire)=UPPER('&p_sos');

	CURSOR c2 IS 
		SELECT a.nrcrt, b.nrcrt
		FROM zboruri_posibile a, zboruri_posibile b
		WHERE UPPER(a.plecare)=UPPER('&p_plec') AND
		      a.sosire=b.plecare AND
		      UPPER(b.sosire)=UPPER('&p_sos') AND
		      a.idzbor <> b.idzbor;

	CURSOR c3 IS 
		SELECT a.nrcrt, b.nrcrt, c.nrcrt
		FROM zboruri_posibile a, zboruri_posibile b, zboruri_posibile c
		WHERE UPPER(a.plecare)=UPPER('&p_plec') AND
		      a.sosire=b.plecare AND b.sosire=c.plecare AND
		      UPPER(c.sosire)=UPPER('&p_sos') AND
		      a.idzbor <> b.idzbor AND b.idzbor <> c.idzbor AND 
		      c.plecare <> a.plecare;

	CURSOR c4 IS 
		SELECT a.nrcrt, b.nrcrt, c.nrcrt, d.nrcrt
		FROM zboruri_posibile a, zboruri_posibile b, zboruri_posibile c, zboruri_posibile d
		WHERE UPPER(a.plecare)=UPPER('&p_plec') AND
		      a.sosire=b.plecare AND b.sosire=c.plecare AND c.sosire=d.plecare AND
		      UPPER(d.sosire)=UPPER('&p_sos') AND
		      a.idzbor <> b.idzbor AND b.idzbor <> c.idzbor AND c.idzbor <> d.idzbor AND
		      c.plecare <> a.plecare AND d.plecare <> a.plecare AND d.plecare <> b.plecare;

	v_nr1 zboruri_posibile.nrcrt%TYPE;
	v_nr2 zboruri_posibile.nrcrt%TYPE;
	v_nr3 zboruri_posibile.nrcrt%TYPE;
	v_nr4 zboruri_posibile.nrcrt%TYPE;
	v_nivel NUMBER(4);
	v_nrvar auto_tr.nrvar%TYPE;

BEGIN
	:rez_er := 0;
	v_nivel := 4; v_nrvar := 1;
	OPEN c1;
	LOOP
		FETCH c1 INTO v_nr1;
		EXIT WHEN c1%NOTFOUND OR c1%NOTFOUND IS NULL;
		v_nivel := 1; 
		INSERT INTO auto_tr (nrvar, idz1) VALUES (v_nrvar, v_nr1);
		v_nrvar := v_nrvar+1;
	END LOOP;
	CLOSE c1;

	IF v_nivel > 1 THEN
		OPEN c2;
		LOOP
			FETCH c2 INTO v_nr1, v_nr2;
			EXIT WHEN c2%NOTFOUND OR c2%NOTFOUND IS NULL;
			v_nivel := 2;
			INSERT INTO auto_tr (nrvar, idz1, idz2) VALUES (v_nrvar, v_nr1, v_nr2);
			v_nrvar := v_nrvar+1;
		END LOOP;
		CLOSE c2;
	END IF;

	IF v_nivel > 2 THEN
		OPEN c3;
		LOOP
			FETCH c3 INTO v_nr1, v_nr2, v_nr3;
			EXIT WHEN c3%NOTFOUND OR c3%NOTFOUND IS NULL;
			v_nivel := 3;
			INSERT INTO auto_tr (nrvar, idz1, idz2, idz3) VALUES (v_nrvar, v_nr1, v_nr2, v_nr3);
			v_nrvar := v_nrvar+1;
		END LOOP;
		CLOSE c3;
	END IF;

	IF v_nivel > 3 THEN
		OPEN c4;
		LOOP
			FETCH c4 INTO v_nr1, v_nr2, v_nr3, v_nr4;
			EXIT WHEN c4%NOTFOUND OR c4%NOTFOUND IS NULL;
			INSERT INTO auto_tr (nrvar,idz1,idz2,idz3,idz4) VALUES (v_nrvar,v_nr1,v_nr2,v_nr3,v_nr4);
			v_nrvar := v_nrvar+1;
		END LOOP;
		CLOSE c4;
	END IF;

	COMMIT;

	IF v_nrvar=1 THEN
		DELETE FROM temp_at;
		INSERT INTO temp_at (info) VALUES ('Eroare - nici o varianta (CTL+C)');
		COMMIT;
		:rez_er := 1;
		RETURN;
	END IF;

END;
/
DECLARE
	CURSOR c1 IS
		SELECT idz1,idz2,idz3,idz4 FROM auto_tr;


	v_nr1 auto_tr.idz1%TYPE;
	v_nr2 auto_tr.idz1%TYPE;
	v_nr3 auto_tr.idz1%TYPE;
	v_nr4 auto_tr.idz1%TYPE;
	v_text temp_at.info%TYPE;
	v_pl orase.nume%TYPE;
	v_sos orase.nume%TYPE;
	v_idzb zboruri.idzbor%TYPE;
	v_varianta NUMBER(4);
	
BEGIN
	IF :rez_er=1 THEN RETURN; END IF;
	OPEN c1;
	v_varianta := 0;
	LOOP
		FETCH c1 INTO v_nr1, v_nr2, v_nr3, v_nr4;
		EXIT WHEN c1%NOTFOUND OR c1%NOTFOUND IS NULL;
		v_varianta := v_varianta+1;
		v_text := 'Varianta ' || v_varianta;
		INSERT INTO temp_at (info) VALUES (v_text);
		IF v_nr2 IS NULL THEN
			SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
				FROM zboruri_posibile
				WHERE nrcrt=v_nr1;

			v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
			INSERT INTO temp_at (info) VALUES (v_text);
		ELSE
			IF v_nr3 IS NULL THEN
				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr1;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);

				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr2;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);
			ELSE
			IF v_nr4 IS NULL THEN
				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr1;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);

				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr2;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);

				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr3;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);
			ELSE
				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr1;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);

				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr2;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);

				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr3;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);

				SELECT idzbor,plecare,sosire INTO v_idzb,v_pl,v_sos
					FROM zboruri_posibile
					WHERE nrcrt=v_nr4;
				v_text := v_idzb || ': ' || v_pl || ' - ' || v_sos;
				INSERT INTO temp_at (info) VALUES (v_text);


			END IF;	
			END IF;	

		END IF;

	END LOOP;
	CLOSE c1;

	v_text := '';
	INSERT INTO temp_at (info) VALUES (v_text);
	COMMIT;
END;
/
SELECT * FROM temp_at
/
DELETE FROM temp_at
/
SET VERIFY OFF
ACCEPT p_var PROMPT 'Numarul variantei (ENTER=1): ' DEFAULT 1
ACCEPT p_val PROMPT 'Introduceti valuta dorita (ENTER=lei): ' DEFAULT lei

VARIABLE var_loc1 NUMBER
VARIABLE var_loc2 NUMBER
VARIABLE var_loc3 NUMBER
VARIABLE var_loc4 NUMBER
VARIABLE var_locdisp NUMBER

VARIABLE var_zb1 NUMBER
VARIABLE var_zb2 NUMBER
VARIABLE var_zb3 NUMBER
VARIABLE var_zb4 NUMBER
VARIABLE var_zbor NUMBER

DECLARE
	vp_zbor NUMBER(5); 
	vp_datacrt DATE;
	vp_dataurm DATE;
	vp_nrzi NUMBER(2);
	vp_z locuri.zile%TYPE;
	vp_day VARCHAR2(3);
	vp_ora locuri.oraplec%TYPE;
	vp_numar NUMBER(4);
	v_dc DATE;
	v_du DATE;
	v_text temp_at.info%TYPE;
	v_zbor NUMBER(5); 
	v_nr1 auto_tr.idz1%TYPE;
	v_nr2 auto_tr.idz1%TYPE;
	v_nr3 auto_tr.idz1%TYPE;
	v_nr4 auto_tr.idz1%TYPE;
	v_numecomp companii.compname%TYPE;
	v_idcomp companii.compid%TYPE;
	v_oraspl orase.nume%TYPE;
	v_orassos orase.nume%TYPE;
	v_tarapl orase.tara%TYPE;
	v_tarasos orase.tara%TYPE;
	v_fusorar orase.ora%TYPE;
	v_tplec zboruri_posibile.tplec%TYPE;
	v_tsos zboruri_posibile.tsos%TYPE;
	v_dur NUMBER(6);
	v_pret zboruri_posibile.pret%TYPE;
	v_curscomp companii.curs%TYPE;
	v_cursdor companii.curs%TYPE;
	v_valcomp companii.valuta%TYPE;
	v_valdor companii.valuta%TYPE;
	v_pilot piloti.numep%TYPE;
	v_idpilot piloti.idp%TYPE;
	v_dist zboruri_posibile.distanta%TYPE;
	v_prettot zboruri_posibile.pret%TYPE;

---------------------------------------------------------------------------------------------------------

FUNCTION urm_pl(vp_zbor IN NUMBER, vp_datacrt IN DATE) RETURN DATE IS
BEGIN
	vp_nrzi := TO_NUMBER(TO_CHAR(vp_datacrt,'D'))+6;

	SELECT zile, oraplec INTO vp_z, vp_ora
		FROM locuri
		WHERE vp_zbor=idzbor;

	FOR i IN vp_nrzi..vp_nrzi+7 LOOP

		IF i<>vp_nrzi OR
		vp_datacrt < TRUNC(vp_datacrt) + TRUNC(vp_ora,-2)/2400 + MOD(vp_ora,100)/1440 THEN
			IF i=vp_nrzi AND SUBSTR(vp_z,MOD(i-1,7)+1,1)='1' THEN
				vp_dataurm := vp_datacrt;
				EXIT;
			END IF;
			IF SUBSTR(vp_z,MOD(i-1,7)+1,1)='1' THEN
				IF    MOD(i-1,7)=0 THEN vp_day:='Mon';
				ELSIF MOD(i-1,7)=1 THEN vp_day:='Tue';
				ELSIF MOD(i-1,7)=2 THEN vp_day:='Wed';
				ELSIF MOD(i-1,7)=3 THEN vp_day:='Thu';
				ELSIF MOD(i-1,7)=4 THEN vp_day:='Fri';
				ELSIF MOD(i-1,7)=5 THEN vp_day:='Sat';
				ELSIF MOD(i-1,7)=6 THEN vp_day:='Sun';
				END IF;

				vp_dataurm := NEXT_DAY(vp_datacrt,vp_day);
				EXIT;
			END IF;
		END IF;
	END LOOP;

	vp_dataurm := TRUNC(vp_dataurm)+ TRUNC(vp_ora,-2)/2400 + MOD(vp_ora,100)/1440;

	RETURN vp_dataurm;
END;
---------------------------------------------------------------------------------------------------------

PROCEDURE scrie_inf(vp_numar IN NUMBER) IS
BEGIN
	SELECT idzbor,plecare,sosire,distanta,pret,tplec,tsos
		INTO v_zbor,v_oraspl,v_orassos,v_dist,v_pret,v_tplec,v_tsos
		FROM zboruri_posibile
		WHERE nrcrt=vp_numar;
	
	:var_zbor := v_zbor;
	v_du := urm_pl(v_zbor,v_dc);

	SELECT companie, pilot INTO v_idcomp, v_idpilot
		FROM zboruri WHERE v_zbor=idzbor;
	SELECT compname, valuta, curs INTO v_numecomp, v_valcomp, v_curscomp
		FROM companii WHERE v_idcomp=compid;
	v_text := v_zbor || ': Compania ' || v_numecomp;
	INSERT INTO temp_at (info) VALUES (v_text);

	SELECT p.numep INTO v_pilot
		FROM piloti p, zboruri z
		WHERE p.idp=z.pilot AND z.idzbor=v_zbor;
	v_text := 'Pilot: ' || v_pilot;
	INSERT INTO temp_at (info) VALUES (v_text);

	SELECT tara,ora INTO v_tarapl,v_fusorar
		FROM orase WHERE nume=v_oraspl;
	v_text := 'Plecare: ' || v_oraspl || ' (' || v_tarapl || ') - ';
	v_text := v_text || TO_CHAR(v_du + v_tplec/1440 + v_fusorar/24,'Dy, DD Mon YYYY, HH24:MI') || ' ora locala';
	INSERT INTO temp_at (info) VALUES (v_text);

	SELECT tara,ora INTO v_tarasos,v_fusorar
		FROM orase WHERE nume=v_orassos;
	v_text := 'Sosire: ' || v_orassos || ' (' || v_tarasos || ') - ';
	v_text := v_text || TO_CHAR(v_du + v_tsos/1440 + v_fusorar/24,'Dy, DD Mon YYYY, HH24:MI') || ' ora locala';
	INSERT INTO temp_at (info) VALUES (v_text);

	v_dur := v_tsos-v_tplec;
	v_text := 'Durata: ';
	IF v_dur>=60 THEN
		v_text := v_text || TRUNC(v_dur/60,0) || ' h ' || MOD(v_dur,60) || ' min';
	ELSE
		v_text := v_text || v_dur || ' min';
	END IF;
	INSERT INTO temp_at (info) VALUES (v_text);

	SELECT locuri_disp INTO :var_locdisp 
		FROM locuri WHERE idzbor=v_zbor;
	v_text := 'Locuri disponibile: ' || :var_locdisp;
	INSERT INTO temp_at (info) VALUES (v_text);


	SELECT curs,valuta INTO v_curscomp,v_valcomp FROM companii WHERE compid=v_idcomp;
	SELECT curs,valuta INTO v_cursdor,v_valdor FROM companii WHERE valuta=LOWER('&p_val');
	v_text := 'Pret: ' || TO_CHAR(v_pret*v_curscomp,'999,999,999.99') || ' ' || v_valcomp;
	IF (v_curscomp<>v_cursdor) THEN
		v_text := v_text || ' = ' || TO_CHAR(v_pret*v_cursdor,'999,999,999.99') || ' ' || v_valdor;
	END IF;
	INSERT INTO temp_at (info) VALUES (v_text);
END;

---------------------------------------------------------------------------------------------------------

BEGIN
	IF :rez_er=1 THEN RETURN; END IF;
	SELECT sysdate INTO v_dc FROM dual;
	v_dc := v_dc - 2/24;  --ora Romaniei

	SELECT idz1,idz2,idz3,idz4 INTO v_nr1,v_nr2,v_nr3,v_nr4
		FROM auto_tr 
		WHERE nrvar=&p_var;

	v_prettot := 0;
	IF v_nr1 IS NOT NULL THEN
		scrie_inf(v_nr1);
		:var_loc1 := :var_locdisp;
		:var_zb1 := :var_zbor;
		v_prettot := v_prettot + v_pret;
	END IF;
	
	IF v_nr2 IS NOT NULL THEN
		v_text := '';
		INSERT INTO temp_at (info) VALUES (v_text);
		v_dc := v_du + v_tsos/1440; 
		scrie_inf(v_nr2);
		:var_loc2 := :var_locdisp;
		:var_zb2 := :var_zbor;
		v_prettot := v_prettot + v_pret;
	END IF;

	IF v_nr3 IS NOT NULL THEN
		v_text := '';
		INSERT INTO temp_at (info) VALUES (v_text);
		v_dc := v_du + v_tsos/1440; 
		scrie_inf(v_nr3);
		:var_loc3 := :var_locdisp;
		:var_zb3 := :var_zbor;
		v_prettot := v_prettot + v_pret;
	END IF;

	IF v_nr4 IS NOT NULL THEN
		v_text := '';
		INSERT INTO temp_at (info) VALUES (v_text);
		v_dc := v_du + v_tsos/1440; 
		scrie_inf(v_nr4);
		:var_loc4 := :var_locdisp;
		:var_zb4 := :var_zbor;
		v_prettot := v_prettot + v_pret;
	END IF;

	SELECT curs,valuta INTO v_cursdor,v_valdor FROM companii WHERE valuta=LOWER('&p_val');
	v_text := ''; INSERT INTO temp_at (info) VALUES (v_text);
	v_text := 'Pret total: ' || TO_CHAR(v_prettot*v_cursdor,'999,999,999.99') || ' ' || v_valdor;
	INSERT INTO temp_at (info) VALUES (v_text);

	COMMIT;

	EXCEPTION
		WHEN NO_DATA_FOUND THEN 
			DELETE FROM temp_at;
			INSERT INTO temp_at (info) VALUES ('Date introduse gresit - No data found (CTL+C)');
			COMMIT;
			:rez_er := 1;
			RETURN;
END;
/
SET PAGESIZE 40
SET LINESIZE 100
TTITLE 'ZBORURI'
COLUMN info HEADING 'Informatii'
SELECT * FROM temp_at
/
DELETE FROM temp_at
/
ACCEPT p_nl PROMPT 'Numar de locuri (ENTER=1): ' DEFAULT 1

DECLARE
	v_good NUMBER(2);

BEGIN
	IF :rez_er=1 THEN RETURN; END IF;
	v_good := 1;
	IF :var_loc1 IS NOT NULL THEN
		IF :var_loc1 < &p_nl THEN
			INSERT INTO temp_at (info) VALUES ('Nu mai sunt locuri la zborul ' || :var_zb1);
			v_good := 0;
		END IF;
	END IF;
	IF :var_loc2 IS NOT NULL THEN
		IF :var_loc2 < &p_nl THEN
			INSERT INTO temp_at (info) VALUES ('Nu mai sunt locuri la zborul ' || :var_zb2);
			v_good := 0;
		END IF;
	END IF;
	IF :var_loc3 IS NOT NULL THEN
		IF :var_loc3 < &p_nl THEN
			INSERT INTO temp_at (info) VALUES ('Nu mai sunt locuri la zborul ' || :var_zb3);
			v_good := 0;
		END IF;
	END IF;
	IF :var_loc4 IS NOT NULL THEN
		IF :var_loc4 < &p_nl THEN
			INSERT INTO temp_at (info) VALUES ('Nu mai sunt locuri la zborul ' || :var_zb4);
			v_good := 0;
		END IF;
	END IF;

	IF v_good=0 THEN
		INSERT INTO temp_at (info) VALUES ('Rezervarea nu s-a efectuat!');
	ELSE
		INSERT INTO temp_at (info) VALUES ('Rezervarea s-a efectuat!');
		IF :var_loc1 IS NOT NULL THEN
			UPDATE locuri SET locuri_disp=:var_loc1-&p_nl WHERE idzbor=:var_zb1;
		END IF;
		IF :var_loc2 IS NOT NULL THEN
			UPDATE locuri SET locuri_disp=:var_loc2-&p_nl WHERE idzbor=:var_zb2;
		END IF;
		IF :var_loc3 IS NOT NULL THEN
			UPDATE locuri SET locuri_disp=:var_loc3-&p_nl WHERE idzbor=:var_zb3;
		END IF;
		IF :var_loc4 IS NOT NULL THEN
			UPDATE locuri SET locuri_disp=:var_loc4-&p_nl WHERE idzbor=:var_zb4;
		END IF;

	END IF;

	COMMIT;

END;
/
SELECT * FROM temp_at
/
DROP TABLE auto_tr
/
SET HEADING OFF
SET PAGESIZE 
SET LINESIZE 80
DROP TABLE temp_at
/
