SET FEEDBACK OFF
DROP TABLE temp_at
/
CREATE TABLE temp_at (info VARCHAR2(75))
/
SET VERIFY OFF
ACCEPT p_zbor PROMPT 'Introduceti zborul: '
ACCEPT p_nrloc PROMPT 'Introduceti numarul de locuri: '

DECLARE 
	v_locdisp locuri.locuri_disp%TYPE;
	v_text VARCHAR2(75);

BEGIN 
	SELECT locuri_disp INTO v_locdisp
		FROM locuri
		WHERE idzbor=&p_zbor;
	IF v_locdisp < &p_nrloc THEN
		IF v_locdisp<>1 THEN
			v_text := 'Eroare - Mai sunt numai ' || v_locdisp || ' locuri disponibile!';
		ELSE
			v_text := 'Eroare - Mai este numai 1 loc disponibil!';
		END IF;
	ELSE
		v_text := 'Rezervare efectuata!';
		UPDATE locuri SET locuri_disp=v_locdisp-&p_nrloc WHERE idzbor=&p_zbor;
	END IF;
	INSERT INTO temp_at (info) VALUES (v_text);
	COMMIT;

	EXCEPTION
	WHEN NO_DATA_FOUND THEN 
		DELETE FROM temp_at;
		INSERT INTO temp_at (info) VALUES ('Date gresite - zborul nu exista');
		COMMIT;
		RETURN;
END;
/
SELECT * FROM temp_at
/
DROP TABLE temp_at
/
