SET FEEDBACK OFF
DROP TABLE preturi
/
CREATE TABLE preturi
        (
        idruta NUMBER(5) NOT NULL,
	pret NUMBER(8,2) NOT NULL 
        )
/
DECLARE
	CURSOR c1 IS 
		SELECT idruta,dist FROM rute;

	v_idruta rute.idruta%TYPE;
	v_dist rute.dist%TYPE;
	v_pret NUMBER(8,2);

BEGIN
	OPEN c1;
	LOOP
		FETCH c1 INTO v_idruta,v_dist;
		EXIT WHEN c1%NOTFOUND OR c1%NOTFOUND IS NULL;

		IF (v_dist<=500) THEN
			v_pret:=25+0.05*v_dist;
		ELSE 
			IF (v_dist<=2000) THEN
				v_pret:=50+0.04*(v_dist-500);
			ELSE 
				v_pret:=110+0.03*(v_dist-2000);
			END IF;
		END IF;

		INSERT INTO preturi (idruta, pret) VALUES (v_idruta, v_pret);
	
	END LOOP;
	CLOSE c1;
COMMIT;
END;
/
