--CREATE SYNONYM z FOR zboruri_posibile
SET FEEDBACK OFF
DROP TABLE temp_pret
/
CREATE TABLE temp_pret (informatii VARCHAR2(75),pret NUMBER(16,6))
/
SET VERIFY OFF
ACCEPT p_oras PROMPT 'Introduceti orasul de plecare: '
ACCEPT p_val PROMPT 'Introduceti valuta dorita (ENTER=lei): ' DEFAULT lei
VARIABLE ip_er NUMBER

DECLARE 
	v_val companii.valuta%TYPE;
	v_curs companii.curs%TYPE;
	v_conf companii.confort%TYPE;
	v_idzbor zboruri_posibile.idzbor%TYPE;
	v_plecare zboruri_posibile.plecare%TYPE;
	v_sosire zboruri_posibile.sosire%TYPE;
	v_dist zboruri_posibile.distanta%TYPE;
	v_pret zboruri_posibile.pret%TYPE;
	v_info VARCHAR2(75);
	v_nr NUMBER(16,6);
	CURSOR c1 IS 
		SELECT idzbor, plecare, sosire, distanta, pret 
		FROM zboruri_posibile
		WHERE UPPER(plecare)=UPPER('&p_oras');

BEGIN
	:ip_er := 1;
	v_val := LOWER('&p_val');
	OPEN c1;
	LOOP
		FETCH c1 INTO v_idzbor, v_plecare, v_sosire, v_dist, v_pret;
		EXIT WHEN c1%NOTFOUND OR c1%NOTFOUND IS NULL;
		
		IF UPPER(v_plecare)=UPPER('&p_oras') THEN
			v_info := '';
			:ip_er := 0;
	
			SELECT curs INTO v_curs
			FROM companii
			WHERE valuta=v_val;

			SELECT c.confort INTO v_conf
			FROM companii c, zboruri zb
			WHERE c.compid=zb.companie AND zb.idzbor=v_idzbor;

			v_nr := v_pret * v_curs * v_conf;

			v_info := v_info || TO_CHAR(v_idzbor) || ': ' || v_plecare || ' - ' || v_sosire || ' (';
			v_info := v_info || TO_CHAR(v_dist) || ' km) = ';
			v_info := v_info || TO_CHAR(v_nr,'999,999,999.99') || ' ' || v_val;

			INSERT INTO temp_pret (informatii,pret) VALUES (v_info,v_nr);
		END IF;
	END LOOP;
	CLOSE c1;

	IF :ip_er=1 THEN
		DELETE FROM temp_pret;
		INSERT INTO temp_pret (informatii,pret) VALUES ('Nici un zbor gasit - orasul nu exista',0);
	END IF;
	
	COMMIT;

	EXCEPTION
	WHEN NO_DATA_FOUND THEN 
		DELETE FROM temp_pret;
		INSERT INTO temp_pret (informatii,pret) VALUES ('Nici un zbor gasit - valuta nu exista',0);
		COMMIT;
		RETURN;
END;
/
SELECT informatii FROM temp_pret
	ORDER BY pret
/
DROP TABLE temp_pret
/
