SET FEEDBACK OFF
DROP TABLE temp_at
/
CREATE TABLE temp_at (info VARCHAR2(75))
/
SET VERIFY OFF
ACCEPT p_plec PROMPT 'Introduceti orasul de plecare: '
ACCEPT p_sos PROMPT 'Introduceti orasul de sosire: '
ACCEPT p_idzbor PROMPT 'Introduceti identificatorul zborului: '
VARIABLE var_idruta NUMBER
VARIABLE var_sens CHAR
VARIABLE var_idorpl NUMBER
VARIABLE var_idorsos NUMBER
VARIABLE eroare NUMBER

DECLARE 
	CURSOR cd IS
		SELECT idruta, a.idoras, b.idoras 
			FROM rute r, orase a, orase b
			WHERE UPPER(a.nume)=UPPER('&p_plec') AND
			      UPPER(b.nume)=UPPER('&p_sos') AND
			      a.idoras=r.loc1 AND b.idoras=r.loc2;
	CURSOR cr IS
		SELECT idruta, a.idoras, b.idoras
			FROM rute r, orase a, orase b
			WHERE UPPER(a.nume)=UPPER('&p_plec') AND
			      UPPER(b.nume)=UPPER('&p_sos') AND
			      a.idoras=r.loc2 AND b.idoras=r.loc1;
	v_idr rute.idruta%TYPE;
	v_idpl orase.idoras%TYPE;
	v_idsos orase.idoras%TYPE;

BEGIN
	:eroare := 0;
	:var_idruta := 0;
	OPEN cd;
	LOOP
		FETCH cd INTO v_idr,v_idpl,v_idsos;
		EXIT WHEN cd%NOTFOUND OR cd%NOTFOUND IS NULL;
		:var_sens := 'D';
		:var_idruta := v_idr;
		:var_idorpl := v_idpl;
		:var_idorsos := v_idsos;		
	END LOOP;
	CLOSE cd;
	OPEN cr;
	LOOP
		FETCH cr INTO v_idr,v_idpl,v_idsos;
		EXIT WHEN cr%NOTFOUND OR cr%NOTFOUND IS NULL;
		:var_sens := 'R';
		:var_idruta := v_idr;
		:var_idorpl := v_idpl;
		:var_idorsos := v_idsos;		
	END LOOP;
	CLOSE cr;
	IF :var_idruta<>0 THEN
		INSERT INTO temp_at (info) VALUES ('Ruta '|| :var_idruta || ' exista (' || :var_sens || ')');
	ELSE
		INSERT INTO temp_at (info) VALUES ('Ruta nu exista');
	END IF;
	SELECT idoras INTO v_idpl FROM orase WHERE UPPER(nume)=UPPER('&p_plec');
	SELECT idoras INTO v_idsos FROM orase WHERE UPPER(nume)=UPPER('&p_sos');
	:var_idorpl := v_idpl;
	:var_idorsos := v_idsos;
	COMMIT;

	EXCEPTION
		WHEN NO_DATA_FOUND THEN 
			DELETE FROM temp_at;
			INSERT INTO temp_at (info) VALUES ('Date introduse gresit - No data found (CTL+C)');
			COMMIT;
			:eroare := 1;
			RETURN;

END;
/
SELECT * FROM temp_at;
DELETE FROM temp_at
/
ACCEPT p_ruta PROMPT 'Introduceti identificatorul rutei (ENTER daca ruta exista): ' DEFAULT :var_idruta
ACCEPT p_dist PROMPT 'Introduceti distanta (ENTER daca ruta exista): ' DEFAULT 0

DECLARE
	v_found NUMBER(3);
	v_idr rute.idruta%TYPE;
	v_text temp_at.info%TYPE;

BEGIN
	IF :eroare=1 THEN RETURN; END IF;
	DELETE FROM temp_at;	
	IF :var_sens IS NULL THEN
		INSERT INTO rute (idruta, loc1, loc2, dist) 
			VALUES (&p_ruta, :var_idorpl, :var_idorsos, &p_dist);
		INSERT INTO temp_at (info) VALUES ('Ruta creata');
	END IF;
	COMMIT;

END;
/
SELECT * FROM temp_at;
DELETE FROM temp_at;
SELECT * FROM rute WHERE idruta=&p_ruta AND :eroare<>1
/
ACCEPT p_comp PROMPT 'Introduceti identificatorul companiei (ENTER=1): ' DEFAULT 1
ACCEPT p_pilot PROMPT 'Introduceti identificatorul pilotului (ENTER=101): ' DEFAULT 101
ACCEPT p_zile PROMPT 'Introduceti zilele de zbor (format xxxxxxx) (ENTER=1111111): ' DEFAULT 1111111
ACCEPT p_ora PROMPT 'Introduceti ora plecarii (format hhmm) (ENTER=0000): ' DEFAULT 0
ACCEPT p_locuri PROMPT 'Introduceti numarul de locuri (ENTER=100): ' DEFAULT 100

DECLARE
	v_loc locuri.nrlocuri%TYPE;

BEGIN
	IF :eroare=1 THEN RETURN; END IF;
	IF :var_sens IS NULL THEN
		:var_sens := 'D';
	END IF;
	INSERT INTO zboruri (idzbor, companie, ruta1, sensr1, pilot) 
		VALUES (&p_idzbor, &p_comp, &p_ruta, :var_sens, &p_pilot);
	INSERT INTO locuri (idzbor, zile, oraplec, nrlocuri, locuri_disp) 
		VALUES (&p_idzbor, '&p_zile', &p_ora, &p_locuri, &p_locuri);
	
	SELECT nrlocuri INTO v_loc FROM locuri WHERE idzbor=&p_idzbor;
	UPDATE locuri SET locuri_disp=v_loc WHERE idzbor=&p_idzbor;
	
	COMMIT;

END;
/
SELECT * FROM temp_at;  
DROP TABLE temp_at
/
@trasee
@zbortot
